% dynamic kennzeichnet ein Prädikat als veränderlich
%
:- dynamic floskelliste/1.


floskelliste(['Hochinteressant','Ich verstehe.', 'Erzähle mir mehr.', 'Was bewegt dich noch?']).

elizaStart :-
    % Befehl zum Schreiben auf der Konsole.
    % nl bewirkt einen Zeilenwechsel (new line).
    write('Hallo, ich bin Eliza, deine Therapeutin.'), nl,
    write('Damit ich dich verstehe, schreibe mir in folgender Form:'), nl,
    write('[ich,habe,sorgen,vor,dem,bevorstehenden,abitur]'),nl,
    elizaSchleife.

elizaSchleife :-
    write('Eliza > '),
    % mit read wird von der Konsole die Eingabe gelesen.
    read(Eingabe), 
    antwort(Eingabe).

antwort(Eingabe) :-
    % member überprüft, ob ein Ausdruck in einer Liste enthalten ist.
    % Durch die beiden aufeinanderfolgenden Zeilen wird geprüft, ob
    % der Ausdruck gleichzeitig in der Eingabe und auch in der Wörterliste
    % enthalten ist.
    member(Ausdruck, Eingabe),
    member(Ausdruck, [ende, verlassen]),
    % Der cut-Operator "!" verhindert eine erneute Ausführung.
    write('Bis zum nächsten Mal. Auf Wiedersehen!'),!;
    
    member(Angehörige, Eingabe),
    member(Angehörige, [kind, sohn, vater, bruder, onkel,  opa]),
    write('Erzähle mir mehr von deinem '), write(Angehörige), write('.'), nl,
    elizaSchleife;
    
    member(Angehörige, Eingabe),
    member(Angehörige, [tochter, mutter, schwester, tante, oma]),
    write('Erzähle mir mehr von deiner '), write(Angehörige), write('.'), nl,
    elizaSchleife;

    member(Tier, Eingabe),
    member(Tier, [hund, fisch, hamster, meerschweinchen, frettchen, känguru, gnu]),
    write('Du hast von deinem '), write(Tier), write(' erzählt. Erzähle mir mehr von deinem '), write(Tier), nl,
    elizaSchleife;
    
    member(Tier, Eingabe),
    member(Tier, [katze, maus, schildkröte, schlange]),
    write('Du hast von deiner '), write(Tier), write(' erzählt. Erzähle mir mehr von deiner '), write(Tier), nl,
    elizaSchleife;

    member(Ausdruck, Eingabe),
    member(Ausdruck, [ hasse, hass, ärger, ärgere, ärgert, traurig,  ekelig, ekel, ekelt]),
    write('Das ist schade. Erzähle mir mehr über deine Gefühle'), nl,
    elizaSchleife;
    
    member(Ausdruck, Eingabe),
    member(Ausdruck, [liebe, freue, freut, überraschend, überrascht]),
    write('Das ist schön. Erzähle mir mehr über deine Gefühle'), nl,
    elizaSchleife;
    
    member(Ausdruck, Eingabe),
    member(Ausdruck, [sorge, sorgen, problem, probleme]),
    write('Beschreibe das Problem genauer.'), nl,
    elizaSchleife;
    %Ziel der folgenden drei Codezeilen (retract/append/asserta) ist es, die Liste so zu verändern, dass das erste Element ans Ende der Liste verschoben wird.
    % [A | B] teilt eine Liste auf in das erste Element A (Kopf) und den Rest der Liste.
    % retract: Das erste Faktum mit dem Prädikat wird aus der Liste entfernt.
    % retract: Da im konkreten Fall nur ein solches Faktum floskelliste existiert, wird dieses komplett entfernt.
    retract(floskelliste([ Nächstes | Rest ])),
    % append(A, B, C) fügt zwei Listen A und B zu einer Liste C zusammen. 
    append(Rest, [ Nächstes ], NeueListe),
    % asserta fügt das Faktum floskelliste(NeueListe) als erstes Faktum zum Prädikat floskelliste ein.
    % Im konkreten Fall gab es vorher (nach retract) kein solches Faktum mehr.
    % Die umstrukturierte neue Liste ist also im konkreten Fall die (einzige) Floskelliste.
    asserta(floskelliste(NeueListe)),
    write(Nächstes), nl,
    elizaSchleife.
