import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.lang.Math;
import java.util.Arrays;
import java.util.Collections;

public class KMeans {
    // Für DATENPUNKT nutzen wir die eigene Klasse DATENPUNKT
    // Für GANZZAHL und KOMMAZAHL verwenden wir die primitiven Datentypen
    // int und double.

    // ---------- Beispieldatensatz (drei dichte Gruppen) ----------
    public static List<DATENPUNKT> BeispieldatenErzeugen() {
        Random random = new Random(42);
        List<DATENPUNKT> daten = new ArrayList<>();

        // Cluster A um (5, 5)
        for (int i = 0; i < 6; i++) {
            daten.add(new DATENPUNKT(random.nextGaussian() * 0.6 + 2, random.nextGaussian() * 0.6 + 5));
        }
        // Cluster B um (12, 2)
        for (int i = 0; i < 6; i++) {
            daten.add(new DATENPUNKT(random.nextGaussian() * 0.6 + 12, random.nextGaussian() * 0.6 + 6));
        }
        // Cluster C um (3, 12)
        for (int i = 0; i < 6; i++) {
            daten.add(new DATENPUNKT(random.nextGaussian() * 0.6 + 8, random.nextGaussian() * 0.6 + 12));
        }
        return daten;
    }

    
    public static List<DATENPUNKT> ClusterzentrenInitialisieren(int k) {
        /**
         * Schritt 2 – wähle k zufällige Datenpunkte als Startzentren.
         * Hier werden diese wie im Lehrtext gegeben vollständig zufällig gewählt, es könnten
         * aber auch gegebene Punkte genommen werden.
         */
        Random random = new Random();
        List<DATENPUNKT> zentren = new ArrayList<>();
        
        // TODO: zentren initialisieren

        return zentren;

    }

    public static double AbstandBerechnen(DATENPUNKT p1, DATENPUNKT p2) {
        /**
         * Euklidischer Abstand.
         */
        return Math.sqrt(Math.pow(p1.x - p2.x, 2) + Math.pow(p1.y - p2.y, 2));
    }

    public static List<Integer> DatenpunkteClusternZuordnen(
            List<DATENPUNKT> daten,
            List<DATENPUNKT> clusterzentren
    ) {
        /**
         * Schritt 3 – jedem Punkt das nächstgelegene Zentrum zuordnen.
         */
        List<Integer> zuordnung = new ArrayList<>();
        
        // TODO: Iteriere über alle Datenpunkte und finde jeweils das nächstgelegene Clusterzentrum

        return zuordnung;
    }

    public static List<DATENPUNKT> ClusterzentrenAktualisieren(
            List<DATENPUNKT> daten,
            List<DATENPUNKT> clusterzentren,
            List<Integer> zuordnung
    ) {
        /**
         * Schritt 4 – Mittelwerte pro Cluster bilden und Zentren verschieben.
         */
        int k = clusterzentren.size();
        double[] summenX = new double[k];
        double[] summenY = new double[k];
        int[] clustergroessen = new int[k];

        Arrays.fill(summenX, 0.0);
        Arrays.fill(summenY, 0.0);
        Arrays.fill(clustergroessen, 0);

       
        // TODO: Aktualisieren der Clusterzentren
        return clusterzentrenNeu;
    }

    public static Object[] kMeansDurchfuehren(
            List<DATENPUNKT> daten,
            int k,
            int iterationen
    ) {
        /**
         * Schritt 5 – iterativer Hauptalgorithmus.
         */
        List<DATENPUNKT> zentren = ClusterzentrenInitialisieren(k);
        List<Integer> zuordnung = null; // Muss initialisiert werden, um im Return-Statement verfügbar zu sein

        for (int it = 0; it < iterationen; it++) {
            // TODO
        }
        return new Object[]{zentren, zuordnung};
    }

    // ---------- Minimal-„Grafik“ mittels ASCII ----------
    public static void FortschrittAusgeben(int iteration,
                                           List<DATENPUNKT> daten,
                                           List<DATENPUNKT> zentren,
                                           List<Integer> zuordnung) {
        /**
         * Zeigt nach jeder Iteration Zentren und eine grobe ASCII-Karte (20 × 20).
         */
        System.out.println("\n=== Iteration " + iteration + " ===");
        for (int idx = 0; idx < zentren.size(); idx++) {
            DATENPUNKT z = zentren.get(idx);
            int count = Collections.frequency(zuordnung, idx);
            System.out.printf("Zentrum %d: (%.2f, %.2f)   Punkte im Cluster: %d%n", idx, z.x, z.y, count);
        }

        int width = 20;
        int height = 20;           // Rastergröße
        double scale = 15.0 / width; // Datenbereich ≈ 0–15
        char[][] raster = new char[height + 1][width + 1];

        for (int i = 0; i < height + 1; i++) {
            Arrays.fill(raster[i], ' ');
        }

        String syms = "abcde"; // Cluster-Marker (bis 5 Cluster)
        for (int i = 0; i < daten.size(); i++) {
            DATENPUNKT dp = daten.get(i);
            int cl = zuordnung.get(i);
            int rx = Math.min((int) (dp.x / scale), width);
            int ry = Math.min((int) (dp.y / scale), height);
            raster[height - ry][rx] = syms.charAt(cl);
        }

        for (int ci = 0; ci < zentren.size(); ci++) {
            DATENPUNKT z = zentren.get(ci);
            int rx = Math.min((int) (z.x / scale), width);
            int ry = Math.min((int) (z.y / scale), height);
            raster[height - ry][rx] = 'X'; // Zentrum als großes X
        }

        for (char[] row : raster) {
            System.out.println(new String(row));
        }
        System.out.println();
    }

    // ---------- Main ----------
    public static void Main() {
        List<DATENPUNKT> daten = BeispieldatenErzeugen();
        int k = 3;
        int iterationen = 5;
        Object[] result = kMeansDurchfuehren(daten, k, iterationen);
        List<DATENPUNKT> finaleZentren = (List<DATENPUNKT>) result[0];

        System.out.print("Finale Zentren: [");
        for (int i = 0; i < finaleZentren.size(); i++) {
            System.out.print(finaleZentren.get(i));
            if (i < finaleZentren.size() - 1) {
                System.out.print(", ");
            }
        }
        System.out.println("]");
    }

    // Wenn als Skript ausgeführt
    public static void main(String[] args) {
        Main();
    }
}