import pandas as pd
from sklearn.cluster import KMeans
from sklearn.metrics import silhouette_score
import numpy as np
import gensim.downloader as api

# Nachrichten laden
# Tipp: CSV Dateien lassen sich mit einem Tabellenkalkulationsprogramm öffnen und somit inspizieren, 
# verschaffen Sie sich also zunächst einen Überblick
df = pd.read_csv("nachrichten.csv")

# 1) kleines Word2Vec-Modell laden  
wv = api.load("glove-wiki-gigaword-50")


# 2) Sätze in Word2Vec-Vektoren umwandeln
def sent2vec(sentence):
    tokens = [w for w in sentence.lower().split() if w in wv]
    return np.mean(wv[tokens], axis=0)

X = np.vstack(df["text"].apply(sent2vec).to_numpy())

# 3)  Optimales k via Silhouettenkoeffizient bestimmen
# Scores bestimmen
bereich = range(3, 6) # Idee: Passen Sie diesen Bereich an, um die Silhouettenkoeffizienten für verschiedene Clustergroessen zu vergleichen
# Hier nutzen wir eine sehr kompakte Schreibweise, um die Silhouettenkoeffizienten für verschiedene k zu berechnen. 
scores = {k: silhouette_score(X, KMeans(k, random_state=0).fit_predict(X))
          for k in bereich}

# Maximum der Scores bestimmen
k_opt = max(scores, key=scores.get)

# 4)  Trainieren & Vergleichen
labels = KMeans(k_opt, random_state=0).fit_predict(X) # Idee: Rufen Sie KMeans auch mit nicht optimalen Clustern auf
print(pd.crosstab(labels, df["category"])) # Gibt eine Tabelle mit den Häufigkeiten der Cluster und (der in diesem Fall bekannten) Kategorien aus