# -*- coding: utf-8 -*-
"""
@author: Johannes Neumeyer
"""

class DateiendungsPruefer:
    """
    DateiendungsPruefer

    Prüft Dateiendungen entsprechend bestimmter Regeln.
    """

    def __init__(self):
        """
        Konstruktor für Objekte der Klasse DateiendungsPruefer.
        Setzt den Startzustand.
        """
        self.aktZustand = 0

    def IstEingabeAkzeptiert(self, zeichenkette):
        """
        Überprüft, ob die Eingabe akzeptiert wird.
        :param zeichenkette: zu überprüfende Eingabe
        :return: True, wenn die Eingabe jpg, jpeg oder png ist.
        """
        self.aktZustand = 0  # Damit die Methode mehrfach ausgeführt werden kann,
                             # muss der Startzustand hier gesetzt werden

        for zeichen in zeichenkette:
            self.AktZeichenVerarbeiten(zeichen)

        if self.aktZustand == 5:
            return True
        else:
            return False

    def AktZeichenVerarbeiten(self, zei):
        """
        Führt abhängig vom aktuellen Zustand und dem aktuellen Zeichen
        die Zustandsübergänge durch.
        Der Fangzustand wird mit -1 codiert.
        :param zei: zu verarbeitendes Zeichen
        """
        if self.aktZustand == 0:
            if zei == 'j':
                self.aktZustand = 1
            else:
                self.aktZustand = -1

        elif self.aktZustand == 1:
            if zei == 'p':
                self.aktZustand = 2
            else:
                self.aktZustand = -1

        elif self.aktZustand == 2:
            if zei == 'e':
                self.aktZustand = 4
            elif zei == 'g':
                self.aktZustand = 5
            else:
                self.aktZustand = -1

        elif self.aktZustand == 4:
            if zei == 'g':
                self.aktZustand = 5
            else:
                self.aktZustand = -1

        else:
            self.aktZustand = -1