class TermAutomat:
    """
    Automat, der testet, ob ein einfacher mathematischer Term korrekt ist.
    
    @author Johannes Neumeyer
    @version 1.0
    """

    def __init__(self):
        """
        Default für Startzustand und Einrichten des Speichers
        """
        self.aktuellerZustand = -1
        self.speicher = []

    def Speichern(self, ch):
        """
        Legt ein Zeichen auf dem Speicher ab
        @param ch: Zeichen
        """
        self.speicher.append(ch)

    def TestenUndLöschen(self, ch):
        """
        Prüft, ob das angegebene Zeichen zuoberst im Speicher liegt und löscht
        es dann
        @param ch das zu testende Zeichen
        @return wahr, wenn das angegebene Zeichen zuoberst im Speicher liegt
        """
        if len(self.speicher) > 0:
            choben = self.speicher.pop()
            return ch == choben
        else:
            return False

    def Z0(self, ch):
        """
        Verarbeitet das Eingabezeichen für den Zustand 0
        @param ch Eingabezeichen
        """
        if '0' <= ch <= '9':
            self.aktuellerZustand = 1
        elif 'a' <= ch <= 'z':
            self.aktuellerZustand = 5
        elif ch == '(':
            self.Speichern('(')
            self.aktuellerZustand = 2
        else:
            self.aktuellerZustand = -1

    def Z1(self, ch):
        """
        Verarbeitet das Eingabezeichen für den Zustand 1
        @param ch Eingabezeichen
        """
        if '0' <= ch <= '9':
            self.aktuellerZustand = 1
        elif ch == ')':
            if self.TestenUndLöschen('('):
                self.aktuellerZustand = 3
            else:
                self.aktuellerZustand = -1
        elif ch in ['+', '-', '*', '/']:
            self.aktuellerZustand = 4
        else:
            self.aktuellerZustand = -1

    def Z2(self, ch):
        """
        Verarbeitet das Eingabezeichen für den Zustand 2
        @param ch Eingabezeichen
        """
        if '0' <= ch <= '9':
            self.aktuellerZustand = 1
        elif 'a' <= ch <= 'z':
            self.aktuellerZustand = 5
        elif ch == '(':
            self.Speichern('(')
            self.aktuellerZustand = 2
        else:
            self.aktuellerZustand = -1

    def Z3(self, ch):
        """
        Verarbeitet das Eingabezeichen für den Zustand 3
        @param ch Eingabezeichen
        """
        if ch == ')':
            if self.TestenUndLöschen('('):
                self.aktuellerZustand = 3
            else:
                self.aktuellerZustand = -1
        elif ch in ['+', '-', '*', '/']:
            self.aktuellerZustand = 4
        else:
            self.aktuellerZustand = -1

    def Z4(self, ch):
        """
        Verarbeitet das Eingabezeichen für den Zustand 4
        @param ch Eingabezeichen
        """
        if '0' <= ch <= '9':
            self.aktuellerZustand = 1
        elif 'a' <= ch <= 'z':
            self.aktuellerZustand = 5
        elif ch == '(':
            self.Speichern('(')
            self.aktuellerZustand = 2
        else:
            self.aktuellerZustand = -1

    def Z5(self, ch):
        """
        Verarbeitet das Eingabezeichen für den Zustand 5
        @param ch Eingabezeichen
        """
        if 'a' <= ch <= 'z':
            self.aktuellerZustand = 5
        elif ch == ')':
            if self.TestenUndLöschen('('):
                self.aktuellerZustand = 3
            else:
                self.aktuellerZustand = -1
        elif ch in ['+', '-', '*', '/']:
            self.aktuellerZustand = 4
        else:
            self.aktuellerZustand = -1

    def ZeichenBearbeiten(self, ch):
        """
        Verarbeitet das nächste Zeichen
        @param ch nächstes Zeichen
        """
        if self.aktuellerZustand == 0:
            self.Z0(ch)
        elif self.aktuellerZustand == 1:
            self.Z1(ch)
        elif self.aktuellerZustand == 2:
            self.Z2(ch)
        elif self.aktuellerZustand == 3:
            self.Z3(ch)
        elif self.aktuellerZustand == 4:
            self.Z4(ch)
        elif self.aktuellerZustand == 5:
            self.Z5(ch)
        else:
            self.aktuellerZustand = -1

    def TermPrüfen(self, text):
        """
        Prüft, ob die übergebene Zeichenkette einen korrekten einfachen
        mathematischen Term darstellt.
        @param text die Zeichenkette
        """
        self.aktuellerZustand = 0
        self.speicher.clear()
        for ch in text:
            self.ZeichenBearbeiten(ch)
        if ((self.aktuellerZustand == 1 or self.aktuellerZustand == 3
                or self.aktuellerZustand == 5)
                and len(self.speicher) == 0):
            print("Der Text stellt einen korrekten Term dar")
        else:
            print("Der Text stellt keinen korrekten Term dar")