
/**
DateiendungsPruefer

- author: Johannes Neumeyer
- version: 1.0
 */
class DateiendungsPrüfer
{
    var aktZustand: Int

    /**
    Konstruktor für Objekte der Klasse DateiendungsPruefer
    Setzt den Startzustand
     */
    init()
    {
        aktZustand = 0
    }

    /**
    Überprüft, ob die Eingabe aktzeptiert wird.
    - parameters:
        - zeichenkette: zu überprüfende Eingabe
     - returns: true, wenn die Eingabe jpg, jpeg oder png ist.
     */
    func IstEingabeAkzeptiert(zeichenkette: String) -> Bool
    {
        aktZustand = 0 // Damit die Methode mehrfach ausgeführt werden kann, muss der Startzustand hier gesetzt werden

        for ch in zeichenkette
        {
            AktZeichenVerarbeiten(zei: ch)
        }

        return aktZustand == 5
    }

    /**
    Führt abhängig vom aktuellen Zustand und dem aktuellen Zeichen die Zustandsübergänge durch.
    Der Fangzustand wird mit -1 codiert.
    - parameters:
        - zei: zu verarbeitendes Zeichen
     */
    private func AktZeichenVerarbeiten(zei: Character)
    {
        switch aktZustand
        {
            case 0:
                switch zei
                {
                    case "j":
                        aktZustand = 1
                    default:
                        aktZustand = -1
                }
            case 1:
                switch zei
                {
                    case "p":
                        aktZustand = 2
                    default:
                        aktZustand = -1
                }
            case 2:
                switch zei
                {
                    case "e":
                        aktZustand = 4
                    case "g":
                        aktZustand = 5
                    default:
                        aktZustand = -1
                }
            case 4:
                switch (zei)
                {
                    case "g":
                        aktZustand = 5
                    default:
                        aktZustand = -1
                }
            default:
                aktZustand = -1
                break
        }
    }
}

let p = DateiendungsPrüfer()
print(p.IstEingabeAkzeptiert(zeichenkette: "jpeg"))
print(p.IstEingabeAkzeptiert(zeichenkette: "png"))
print(p.IstEingabeAkzeptiert(zeichenkette: "abc"))
