/**
Automat, der testet, ob ein einfacher mathematischer Term korrekt ist.

- author: Albert Wiedemann
- version: 1.0
 */
class TermAutomat
{
    /** Die Nummer des aktuellen Zustands */
    private var aktuellerZustand: Int
    /** Gespeicherte Zustandsinformation */
    private var speicher: Array<Character>

    /**
    Default für Startzustand und Einrichten des Speichers
     */
    init()
    {
        aktuellerZustand = -1
        speicher = []
    }
 
    /**
    Legt ein Zeichen auf dem Speicher ab
    - parameters:
        - ch: Zeichen
     */
    private func Speichern(ch: Character)
    {
        speicher.append(ch)
    }
    
    /**
    Prüft, ob das angegebene Zeichen zuoberst im Speicher liegt und löscht es dann
    - parameters:
        - ch: das zu testende Zeichen
    - returns: wahr, wenn das angegebene Zeichen zuoberst im Speicher liegt
     */
    private func TestenUndLöschen(ch: Character) -> Bool
    {
        if speicher.count > 0
        {
            let choben = speicher.removeLast()
            return ch == choben
        }
        else
        {
            return false
        }
    }
    
    /**
    Verarbeitet das Eingabezeichen für den Zustand 0
    - parameters:
        - ch: Eingabezeichen
     */
    private func Z0(ch: Character)
    {
        if ("0" <= ch) && (ch <= "9")
        {
            aktuellerZustand = 1
        }
        else if ch == "("
        {
            Speichern(ch: "(")
            aktuellerZustand = 2
        }
        else
        {
            aktuellerZustand = -1
        }
    }
    
    /**
    Verarbeitet das Eingabezeichen für den Zustand 1
    - parameters:
        - ch: Eingabezeichen
     */
    private func Z1(ch: Character)
    {
        if ("0" <= ch) && (ch <= "9")
        {
            aktuellerZustand = 1
        }
        else if ch == ")"
        {
            if (TestenUndLöschen(ch: "("))
            {
                aktuellerZustand = 3
            }
            else
            {
                aktuellerZustand = -1
            }
        }
        else if (ch == "+") || (ch == "-") || (ch == "*") || (ch == "/")
        {
            aktuellerZustand = 4
        }
        else
        {
            aktuellerZustand = -1
        }
    }
    
    /**
    Verarbeitet das Eingabezeichen für den Zustand 2
    - parameters:
        - ch: Eingabezeichen
     */
    private func Z2(ch: Character)
    {
        if ("0" <= ch) && (ch <= "9")
        {
            aktuellerZustand = 1
        }
        else if ch == "("
        {
            Speichern(ch: "(");
            aktuellerZustand = 2
        }
        else
        {
            aktuellerZustand = -1
        }
    }
    
    /**
    Verarbeitet das Eingabezeichen für den Zustand 3
    - parameters:
        - ch: Eingabezeichen
     */
    private func Z3(ch: Character)
    {
        if ch == ")"
        {
            if (TestenUndLöschen(ch: "("))
            {
                aktuellerZustand = 3;
            }
            else
            {
                aktuellerZustand = -1;
            }
        }
        else if (ch == "+") || (ch == "-") || (ch == "*") || (ch == "/")
        {
            aktuellerZustand = 4
        }
        else
        {
            aktuellerZustand = -1
        }
    }
    
    /**
    Verarbeitet das Eingabezeichen für den Zustand 4
    - parameters:
        - ch: Eingabezeichen
     */
    private func Z4(ch: Character)
    {
        if ("0" <= ch) && (ch <= "9")
        {
            aktuellerZustand = 1
        }
        else if ch == "("
        {
            Speichern(ch: "(");
            aktuellerZustand = 2
        }
        else
        {
            aktuellerZustand = -1
        }
    }
    
    /**
    Verarbeitet das nächste Zeichen
    - parameters:
        - ch: nächstes Zeichen
     */
    private func ZeichenBearbeiten(ch: Character)
    {
        switch (aktuellerZustand)
        {
            case 0:
                Z0(ch: ch)
            case 1:
                Z1(ch: ch)
            case 2:
                Z2(ch: ch)
            case 3:
                Z3(ch: ch)
            case 4:
                Z4(ch: ch)
            default:
                aktuellerZustand = -1
        }
    }

    /**
    Prüft, ob die übergebene Zeichenkette einen korrekten einfachen mathematischen Term darstellt.
    - paramweters:
        - text: die Zeichenkette
     */
    func TermPrüfen(text: String)
    {
        aktuellerZustand = 0
        speicher.removeAll()
        for ch in text
        {
            ZeichenBearbeiten(ch: ch)
        }
        if ((aktuellerZustand == 1) || (aktuellerZustand == 3)) && (speicher.count == 0)
        {
            print("Der Text stellt einen korrekten Term dar")
        }
        else
        {
            print("Der Text stellt keinen korrekten Term dar")
        }
    }
}

let a = TermAutomat()
a.TermPrüfen(text: "7-(45+3)*8")
a.TermPrüfen(text: "3+-4")
a.TermPrüfen(text: "((3+4)*7")

