
/**
 * Verwaltet den Zwischenspeicher und stellt ihn dar.
 * 
 * @author Johannes Neumeyer
 * @version 1.0
 */
class Speicher extends Rechteck
{
    /** Gibt an, ob Platz frei ist */
    private boolean frei;
    /** Die eventuell vorhandene Kiste */
    private Kiste kiste;
    /** zur Steuerung der Kistendarstellung */
    private Kiste kistendarstellung;

    /**
     * Besetzt die Attribute vor.
     */
    Speicher()
    {
        frei = true;
        kiste = null;
        kistendarstellung = new Kiste(-1);
        kistendarstellung.SichtbarkeitSetzen(false);

        GrößeSetzen(50, 10);
        FarbeSetzen("grau");
        PositionSetzen(375, 250);
    }

    /**
     * Versucht, eine Kiste abzulegen und wartet gegebenenfalls.
     * @param kiste die abzulegende Kiste
     */
    synchronized boolean Ablegen(Kiste kisteNeu)
    {
        if (frei)
        {
            frei = false;
            kiste = kisteNeu;
            kiste.ImSpeicherDarstellen();
            return true;
        }
        return false;
    }

    /**
     * Versucht, eine Kiste zu holen und wartet gegebenenfalls.
     * @return die geholte Kiste
     */
    synchronized Kiste Holen()
    {
        if (!frei)
        {
            frei = true;
            Kiste kNeu = kiste; 
            kiste.SpeicherdarstellungVerbergen();
            kiste = null;
            return kNeu;
        }
        return null;
    }
}
