# -- coding: utf-8 --

import abc, time
from graphics_and_games_klassen import Figur, Ereignisbehandlung


class LageristenSymbol(Figur):
    """
    Darstellung eines Lageristen
    """
    
    def __init__(self, helmfarbe, nummer):
        """
        Konstruktor für Objekte der Klasse LageristenSymbol
        """
        super().__init__()
        # Kopf von oben
        self.FigurteilFestlegenEllipse(-50, -10, 20, 20, helmfarbe)
        # Kiste von oben
        self.FigurteilFestlegenRechteck(-30, -40, 80, 80, "braun")
        self.PositionSetzen(50, 100 + 100 * nummer)

        
    
    def Warten(self, millis):
        """
        Unterbricht die Programmausführung für die angegebene Zeit.
        """
        time.sleep(millis/1000)



class Lagerist:
    """Lagerist in einem Lager"""

    def __init__(self, helmfarbe, nummer):
        """Konstruktor für Objekte der Klasse Lagerist"""
        self.symbol = LageristenSymbol(helmfarbe, nummer)

    def Arbeiten(self):
        while self.symbol.XPositionGeben() < 763:
            self.symbol.Gehen(1)
            self.symbol.Warten(5)


# Erzeuge zwei Lageristen:
l1 = Lagerist("blau", 1)
l2 = Lagerist("rot", 2)

# Warte kurz, bis sich das Zeichenfenster aufgebaut hat:
time.sleep(1)

# Lasse die Lageristen arbeiten:  
l1.Arbeiten()
l2.Arbeiten()
