import time, math, random, sys, multiprocessing

def istPrimzahl(x):
    if x < 2:
        return False
    if x == 2:
        return True
    max = int(math.ceil(math.sqrt(x)))
    i = 2
    while i <= max:
        if x % i == 0:
            return False
        i += 1
    return True

def summierePrimzahlenBis(n):
    return sum([x for x in range(2, n) if istPrimzahl(x)])

if __name__=="__main__":
    anzahl_threads = int(sys.argv[1])
    eingabewerte = [random.randint(10000, 100000) for x in range(500)]
    
    if anzahl_threads > 0:
        pool = multiprocessing.Pool(anzahl_threads)
        start_time = time.time()
        jobs = zip(eingabewerte, pool.map(summierePrimzahlenBis, eingabewerte))
        print ("Anzahl Threads:", anzahl_threads, "\tLaufzeit:", time.time() - start_time, "s")
