import threading, random, time

class Sensor (threading.Thread):
    typ = 'Generische Sensorsimulation'
    anzeige = None
    
    def setAnzeige(self, anzeige):
        self.anzeige = anzeige
    
    def getMesswert(self):
        return 'Ich bin nur ein Dummysensor'
    
    def run(self):
        while True:
            # Zwei Sekunden Wartezeit zwischen den Messwertausgaben
            time.sleep(2)
            
            # Simulierten Messwert generieren und ausgeben
            messwert = self.getMesswert()
            if self.anzeige is not None:
                textzeile = 'Sensor: ' + self.typ + '\tMesswert: ' + str(messwert) + '\n'
                self.anzeige.textAusgeben(textzeile)


class Temperatursensor(Sensor):
    typ = 'Temperatur'
    
    def getMesswert(self):
        return str(random.randint(-10, 41)) + ' °C'


class Luftdrucksensor(Sensor):
    typ = 'Luftdruck'
    
    def getMesswert(self):
        return str(1013 + random.randint(-10, 10)) + ' hPa'


class Luftfeuchtesensor(Sensor):
    typ = 'Luftfeuchte'
    
    def getMesswert(self):
        return str(random.randint(0, 101)) + ' %'


class Windgeschwindigkeitssensor(Sensor):
    typ = 'Windgeschwindigkeit'
    
    def getMesswert(self):
        return str(random.randint(0, 201)) + ' km/h'


class Windrichtungssensor(Sensor):
    typ = 'Windrichtung'
    
    def getMesswert(self):
        return ['N', 'NO', 'O', 'SO', 'S', 'SW', 'W', 'NW' ][random.randint(0, 7)]
    

