import threading
import random
import time
from graphics_and_games_klassen import Rechteck, Text, Dreieck

from intern.zeichenfenster import Zeichenfenster

class Baeuerin(threading.Thread):
    """
    Bäuerin, die einen Eierautomaten betreibt
    """
    def __init__(self, eierautomat):
        """
        Konstruktor für Objekte der Klasse Baeuerin
        :param eierautomat: der zu verwendene Eierautomat
        """
        super().__init__()
        self.automat = eierautomat # der zu verwendene Eierautomat
        self.zufallsgenerator = random.Random() # Zufallsgenertator zum Erzeugen einer zufälligen Wartezeit
        self.ausgabeBaeuerin = Text() # Textanzeige
        self.ausgabeBaeuerin.PositionSetzen(50, 200)
        self.anzahlVersuche = 0 # Zähler für die Anzahl der Zugriffsversuche

    def run(self):
        """
        Die Bäuerin versucht in unregelmäßigen Zeitabständen, 
        den Eierautomaten wieder neu zu befüllen.
        """
        while True:
            # Textausgabe
            self.anzahlVersuche += 1
            self.ausgabeBaeuerin.TextSetzen(f"{self.anzahlVersuche}. Befüllbesuch")
            # Automatenbefüllversuch
            self.automat.Befuellen()
            
            # Simulation der Zeitdauer zwischen zwei Befüllversuchen
            time.sleep(self.zufallsgenerator.randint(0, 4000) / 1000)

class BessererEierautomat:
    """
    Besserer Eierautomat auf dem Lande
    """
    def __init__(self):
        self.condition = threading.Condition()
        self.eierkartons = []

        self.automat = Rechteck()
        self.automat.GroesseSetzen(100, 200)
        self.automat.FarbeSetzen("grau")
        self.automat.PositionSetzen(350, 200)
        self.dach = Dreieck()
        self.dach.GroesseSetzen(140, 50)
        self.dach.FarbeSetzen("rot")
        self.dach.PositionSetzen(400, 150)

    def Befuellen(self):
        """
        Befüllen des Eierautomaten mit neuen Eierkartons
        """
        with self.condition:
            # So lange der Automat noch Eierkartons enthält, muss mit dem Befüllen gewartet werden.
            while len(self.eierkartons) > 0:
                self.condition.wait()
            # Der leere Automat wird mit zehn neuen Kartons befüllt.
            for zaehler in range(10):
                karton = Eierkarton()
                karton.PositionSetzen(375, 205 + 20 * zaehler)
                self.eierkartons.append(karton)

            # Der Zustand der Variable in der Wartebedingung hat sich verändert.
            # Ein wartender Thread wird benachrichtigt.
            self.condition.notify()

    def EierHolen(self):
        """
        Holen eines Eierkartons aus dem Automaten
        :return: Eierkarton oder null bei Fehlversuch
       """

        # solange eine bestimmte Bedingung gilt, müssen Abholer abwarten
        # --- HIER PROGRAMMCODE ERGÄNZEN
        # --- HINWEIS: Die Bedingung um die folgenden Anweisungen könnte dann entfernt werden,
        # --- ebenso die Rückgabe der leeren Referenz.
        
        with self.condition:
            # Ein Eierkarton wird aus dem Feld entfernt und seine Darstellung aus dem Zeichenfenster
            if len(self.eierkartons) > 0:
                gekaufterKarton = self.eierkartons.pop(0)
                gekaufterKarton.Entfernen()
                # Rueckgabe des gekauften Kartons
                return gekaufterKarton
            return None

class Eierautomat:
    """
    Eierautomat auf dem Lande
    """
    def __init__(self):
        self.condition = threading.Condition()
        self.eierkartons = []

        self.automat = Rechteck()
        self.automat.GroesseSetzen(100, 200)
        self.automat.FarbeSetzen("grau")
        self.automat.PositionSetzen(350, 200)
        self.dach = Dreieck()
        self.dach.GroesseSetzen(140, 50)
        self.dach.FarbeSetzen("rot")
        self.dach.PositionSetzen(400, 150)

    def Befuellen(self):
        """
        Befüllen des Eierautomaten mit neuen Eierkartons
        """
        with self.condition:
            #  Der leere Automat wird mit zehn neuen Kartons befüllt.
            if len(self.eierkartons) == 0:
                for zaehler in range(10):
                    self.eierkartons.append(Eierkarton())
                    self.eierkartons[zaehler].PositionSetzen(375, 205 + 20 * zaehler)

    def EierHolen(self):
        """
        Holen eines Eierkartons aus dem Automaten
        :return: Eierkarton oder null bei Fehlversuch
        """
        with self.condition:
            # Ein Eierkarton wird aus dem Feld entfernt und seine Darstellung aus dem Zeichenfenster
            if len(self.eierkartons) > 0:
                gekaufterKarton = self.eierkartons.pop(0)
                gekaufterKarton.Entfernen()
                # Rueckgabe des gekauften Kartons
                return gekaufterKarton
            return None

class Eierkarton(Rechteck):
    """
    Eierkarton
    """
    def __init__(self):
        super().__init__()
        # Legt das Aussehen des Kartons fest
        self.GroesseSetzen(50, 15)
        self.FarbeSetzen("blau")

class Landleben:
    """
    Befuellen und Entleeren eines ländlichen Eierautomaten
    """
    def __init__(self):
        """
        Konstruktor für Objekte der Klasse Landleben
        """
        self.automat = BessererEierautomat()
        self.b = Baeuerin(self.automat)
        self.l = Leo(self.automat)
        self.b.start()
        self.l.start()

class Leo(threading.Thread):
    """
    Leo, ein extremer Eierkonsument
    """
    def __init__(self, eierautomat):
        """
        Konstruktor für Objekte der Klasse Leo
        """
        super().__init__()
        self.automat = eierautomat
        self.zufallsgenerator = random.Random()
        self.ausgabeAnna = Text()
        self.ausgabeAnna.PositionSetzen(550, 200)
        self.anzahlVersuche = 0

    def run(self):
        while True:
            self.anzahlVersuche += 1
            self.ausgabeAnna.TextSetzen(f"{self.anzahlVersuche}. Eierholbesuch")
            self.automat.EierHolen()
            time.sleep(self.zufallsgenerator.randint(0, 200) / 1000)


if __name__ == "__main__":
    Landleben()


    Zeichenfenster().run()