import threading
import random
import time

class Boot(threading.Thread):
    """
    Boot auf dem Chiemsee
    """
    def __init__(self, kennzeichenNeu, stegNeu):
        super().__init__()
        self.kennzeichen = kennzeichenNeu
        self.steg = stegNeu
        self.zufallsgenerator = random.Random()
    
    def run(self):
        while True:
            # Damit der Fehler schnell entsteht, wurden die Wartezeiten jeweils auskommentiert
             
            # Zeit auf dem See herumfahren
            #time.sleep(self.zufallsgenerator.randint(1, 100)/10)
            self.steg.PlatzReservieren(self)
            # Zeit am Steg liegen
            #time.sleep(self.zufallsgenerator.randint(1, 300)/10)
            self.steg.PlatzFreigeben(self)
    
    def KennzeichenGeben(self):
        return self.kennzeichen


class Stegverwaltung:
    """
    Verwaltung eines Stegs am Chiemsee
    """
    def __init__(self):
        self.boote = []
        self.bootanzahl = 0
        self.fehler = False
    
    def PlatzReservieren(self, bootAn):        
        while self.bootanzahl >= 10:
            pass
        self.boote.append(bootAn)
        self.bootanzahl += 1
        if self.bootanzahl > 10:
            self.fehler = True
        print(f"Boot {bootAn.KennzeichenGeben()} angelegt --> Boote am Steg: {self.bootanzahl}")

    def PlatzFreigeben(self, bootAb):
        self.boote.remove(bootAb)
        self.bootanzahl -= 1
        if self.bootanzahl < 0:
            self.fehler = True
        print(f"Boot {bootAb.KennzeichenGeben()} abgelegt --> Boote am Steg: {self.bootanzahl}")


class Chiemsee:
    """
    Verwaltet alle Boote
    """
    def __init__(self):
        self.steg = Stegverwaltung()
        for i in range(15):
            boot = Boot(i, self.steg)
            boot.start()

if __name__ == "__main__":
    chiemsee = Chiemsee()
