import threading
import time

class Parkplatz:
    """
    Parkplatz

    Gibt an, ob der Parkplatz belegt ist oder nicht.
    """
    def __init__(self):
        """
        Konstruktor für Objekte der Klasse Parkplatz
        """
        self.frei = True

    def Beparken(self, kennzeichen):
        """
        Falls der Parkplatz frei ist, wird er beparkt.
        :param kennzeichen: Kennzeichen des Fahrzeugs
        :return: wahr, wenn der Platz beparkt werden konnte
        """
        if self.frei:
            self.frei = False
            print(f"{kennzeichen} erfolgreich eingeparkt.")
            return True
        print(f"Parkplatz belegt. Fahrzeug {kennzeichen} fährt um den Block.")
        return False

    def Ausparken(self, kennzeichen):
        """
        Der Parkplatz wird verlassen.
        :param kennzeichen: Kennzeichen des Fahrzeugs
        """
        print(f"{kennzeichen} ausgeparkt.")
        self.frei = True


class Fahrzeug(threading.Thread):
    """
    Fahrzeug im Verkehr
    """
    def __init__(self, kennzeichenNeu, parkplatz):
        """
        Konstruktor für Objekte der Klasse Fahrzeug
        :param kennzeichenNeu: Kennzeichen des Fahrzeugs
        :param parkplatz: der gewünschte Parkplatz
        """
        super().__init__()
        self.kennzeichen = kennzeichenNeu
        self.zielParkplatz = parkplatz

    def run(self):
        """
        Das Fahrzeug versucht permanent, den gewünschten Parkplatz zu belegen.
        Anschließend parkt es wieder aus und "fährt um den Block",
        um dann wieder von Neuem zu beginnen.
        """
        while True:
            # Einparkversuch
            eingeparkt = self.zielParkplatz.Beparken(self.kennzeichen)
            # Der Parkplatz war frei.
            if eingeparkt:
                # Parken
                time.sleep(2.5)  # Simuliertes Parken für 2.5 Sekunden
                # Ausparken
                self.zielParkplatz.Ausparken(self.kennzeichen)
            # Um den Block fahren
            time.sleep(5)  # Simuliert das "Um den Block Fahren" für 5 Sekunden



# Beispielcode zur Demonstration der Ausführung
if __name__ == "__main__":
    p = Parkplatz()
    for id in range(10):
        f = Fahrzeug(id, p)
        f.start()
