from threading import Thread, Lock, Condition
import time
import random
import math

from graphics_and_games_klassen import Rechteck, Text, Kreis

from intern.zeichenfenster import Zeichenfenster

class Gabel:
    """ Gabel zwischen zwei Philosophen """
    def __init__(self, gabel_id):
        self.in_benutzung = False
        self.id = gabel_id
        self.symbol = Rechteck()
        self.symbol.FarbeSetzen("schwarz")
        self.lock = Lock()
        self.condition = Condition(self.lock)


    def aufnehmen(self, eigene_farbe):
        """ Nimmt die Gabel auf, wenn sie nicht benutzt wird, sonst wartet der Thread. """
        with self.lock:
            while self.in_benutzung:
                self.condition.wait()
            self.in_benutzung = True
            self.symbol.FarbeSetzen(eigene_farbe)

    def ablegen(self):
        """ Legt die Gabel ab und setzt die Farbe zurück auf schwarz. """
        with self.lock:
            self.in_benutzung = False
            self.symbol.FarbeSetzen("schwarz")
            self.condition.notify()
        

class Philosoph(Thread):
    """ Speisender Philosoph """
    def __init__(self, philosophen_id, teller, tellerfarbe, gabel_links, gabel_rechts):
        super().__init__()
        self.id = philosophen_id
        self.teller = teller
        self.tellerfarbe = tellerfarbe
        self.gabel_links = gabel_links
        self.gabel_rechts = gabel_rechts
        self.wartezeit = 10
        self.ran = random.Random()

    def run(self):
        """ Hauptmethode des Threads, die den Zyklus des Denkens, Essens usw. steuert. """
        while True:
            time.sleep(self.ran.randint(0, self.wartezeit) / 1000.0)  # Denken in Sekunden
            self.gabel_links.aufnehmen(self.tellerfarbe)
            self.gabel_rechts.aufnehmen(self.tellerfarbe)

            time.sleep(self.ran.randint(0, self.wartezeit) / 1000.0)  # Essen in Sekunden
            self.gabel_links.ablegen()
            self.gabel_rechts.ablegen()

class SpeisendePhilosophen:
    """ Visualisierung des Problems der speisenden Philosophen """
    def __init__(self):
        self.gabeln = []
        self.teller = []
        self.tellerfarben = ["rot", "blau", "grün", "magenta", "grau"]
        self.philosophen = []

        anleitung = Text()
        anleitung.TextSetzen("Abgelegte Gabeln sind schwarz, aufgenommene Gabeln haben die Farbe ihres aktuellen Besitzers.")
        anleitung.PositionSetzen(10, 50)
        anleitung.TextGroesseSetzen(17)

        for zaehler in range(5):
            self.gabeln.append(Gabel(zaehler))
            self.gabeln[zaehler].symbol.GroesseSetzen(100, 10)
            self.gabeln[zaehler].symbol.PositionSetzen(350 + int(150 * math.cos(math.radians(54 + 72 * zaehler))),
                                                       295 - int(150 * math.sin(math.radians(54 + 72 * zaehler))))
            self.gabeln[zaehler].symbol.Drehen(54 + 72 * zaehler)

            self.teller.append(Kreis())
            self.teller[zaehler].RadiusSetzen(50)
            self.teller[zaehler].FarbeSetzen(self.tellerfarben[zaehler])
            self.teller[zaehler].PositionSetzen(400 + int(175 * math.cos(math.radians(18 + 72 * zaehler))),
                                                 300 - int(175 * math.sin(math.radians(18 + 72 * zaehler))))

        for zaehler in range(5):
            phil = Philosoph(zaehler, self.teller[zaehler], self.tellerfarben[zaehler], self.gabeln[(zaehler - 1) % 5], self.gabeln[zaehler])
            self.philosophen.append(phil)
            phil.start()



SpeisendePhilosophen()
Zeichenfenster().run() 
