import Foundation


/**
Darstellung eines Lageristen

- author: Johannes Neumeyer
- version: 1.0
*/
class LageristenSymbol: Figur
{
    /**
    Konstruktor für Objekte der Klasse LageristenSymbol
     - parameters:
        - helmfarbe: die Farbe des Helms des Lageristen
        - nummer: die Nummer der Kiste
    */
    init(helmfarbe: String, nummer: Int)
    {
        super.init()
        // Kopf von oben
        FigurteilFestlegenEllipse(x: -50, y: -10, breite: 20, höhe: 20, farbe: helmfarbe);
        // Kiste von oben
        FigurteilFestlegenRechteck(x: -30, y: -40, breite: 80, höhe: 80, farbe: "braun");
        PositionSetzen(x: 50, y: 100 + 100 * nummer);
    }
    
    /**
    Unterbricht die Programmausführung für die angegebene Zeit.
     - parameters:
     -  millis: Wartezeit in Millisekunden
    */
    func Warten(millis: Int)
    {
        Thread.sleep(forTimeInterval: TimeInterval(millis) / 1000)
    }
}

/**
Lagerist in einem Lager

- author: Johannes Neumeyer
- version: 1.0
*/
class Lagerist
{
    /** graphische Darstellung des Lageristen */
    var symbol: LageristenSymbol

    /**
    Konstruktor für Objekte der Klasse Lagerist
     - parameters:
        - helmfarbe: die Farbe des Helms des Lageristen
        - nummer: die Nummer der Kiste
    */
    init(helmfarbe: String, nummer: Int)
    {
        symbol = LageristenSymbol(helmfarbe: helmfarbe, nummer: nummer)
    }

    /**
    Schiebt eine Kiste bis zum rechten Rand des Zeichenfensters.
    */
    func Arbeiten()
    {
        while symbol.XPositionGeben() < 763
        {
            symbol.Gehen(länge: 1)
            symbol.Warten(millis: 5)
        }
    }
}

/**
Lagerarbeit

- author: Johannes Neumeyer
- version: 1.0
 */
class Lagerarbeit
{
    /** zwei Lageristen */
    var l1, l2: Lagerist

    /**
    Konstruktor für Objekte der Klasse Lagerarbeit
     */
    init()
    {
        l1 = Lagerist(helmfarbe: "blau", nummer: 1)
        l2 = Lagerist(helmfarbe: "rot", nummer: 2)
        
        l1.Arbeiten()
        l2.Arbeiten()
    }
}

Lagerarbeit()
