import Foundation

/**
Arbeitsthread
 */
class Arbeitsthread: Thread
{
    /** Feld der Eingabewerte*/
    private static let werte: [Int] = WerteGenerieren()
    /** Postion des nächsten Werts im  Eingabefeld */
    private static var pos = 0
    /** Monitor zum Zugriff auf die Eingabewertposition */
    private static let monitor = NSLock()
    
    /**
     Besetzt das Feld der Eingabewerte vor
     - returns: Eingabewerte
     */
    private static func WerteGenerieren() -> [Int]
    {
        var eingabewerte = [Int]()
        for i in 0 ..< 500
        {
            eingabewerte.append(Int.random(in: 100000 ..< 1000001))
        }
        return eingabewerte
    }
    
    /** Gibt den nächsten Wert aus dem Eingabefeld zurück
     - returns: nächster Wert oder nil
     */
    private static func NächsterWert() -> Int?
    {
        monitor.lock()
        let res = pos < werte.count ? werte[pos] : nil
        pos += 1
        monitor.unlock()
        return res
    }
    
    /**
     Stellt den Startzustand her, d. h. die Werteposition  auf 0
     */
    static func StartZustandHerstellen()
    {
        pos = 0
    }
    
    /**
     Meldet, ob alle Werte im Feld abgearbeitet sind
     - returns: wahr, wenn alle Werte durch sind
     */
    static func AlleWerteAbgearbeitet() -> Bool
    {
        return pos >= werte.count
    }
    
    /**
     Testet, ob x eine Primzahl ist
     - parameters:
         - x: die zu testende Zahl
     - returns: wahr, wenn x eine Primzahl ist
     */
    private func IstPrimzahl(x: Int) -> Bool
    {
        if x < 2
        {
            return false
        }
        if x == 2
        {
            return true
        }
        let max = Int(sqrt(Double(x)))
        var i = 2
        while i <= max
        {
            if x % i == 0
            {
                return false
            }
            i += 1
        }
        return true
    }

    /**
     Bildet die Summe der Primzahlen bis zum Maximalwert
     - parameters:
         -  bis: bis hierher wird dei Summe gebildet
     - returns: Primzahlumme
     */
    private func PrimzahlenSummieren(bis n: Int) -> Int
    {
        var summe = 0
        for i in  2 ..< n
        {
            if IstPrimzahl(x: i)
            {
                summe += i
            }
        }
        return summe
    }

    /**
     Arbeitsmethode des Threads
     */
    override func main()
    {
        while let wert = Arbeitsthread.NächsterWert()
        {
            //print("Summe der Primzahlen bis \(wert) ist: \(PrimzahlenSummieren(bis: wert))")
            _ = PrimzahlenSummieren(bis: wert)
        }
    }
}


/**
 Laufzeittest
 */
class Benchmark
{
    /**
     Startet den Laufzeittest für die gegebene Anzahl von Threads
     - parameters:
        -   anzahlThreads: Anzahl der Arbeitersthreads
     */
    static func TestStarten(anzahlThreads: Int)
    {
        if (anzahlThreads > 0)
        {
            Arbeitsthread.StartZustandHerstellen()
            let startZeit = Date.now
            for _ in 0..<anzahlThreads
            {
                Arbeitsthread().start()
            }
            while !Arbeitsthread.AlleWerteAbgearbeitet()
            {
                Thread.sleep(forTimeInterval: 0.001)
            }
            let endZeit = Date.now
            let laufzeit = endZeit.timeIntervalSince(startZeit)
            print("Anzahl Threads: \(anzahlThreads) \tLaufzeit: \(laufzeit)s")
        }
    }
}

for i in 2 ..< 10
{
    Benchmark.TestStarten(anzahlThreads: i)
}
