import Foundation

/**
Eierkarton

- author: Johannes Neumeyer
- version: 1.0
*/
class Eierkarton: Rechteck
{
    
    /**
    Legt das Aussehen des Kartons fest
    */
    override init()
    {
        super.init()
        GrößeSetzen(breite: 50, höhe: 15)
        FarbeSetzen(farbe: "grün")
    }
}


/**
Eierautomat auf dem Lande

- author: Johannes Neumeyer
- version: 1.0
*/
class Eierautomat
{
    /** Feld, das die Eierkartons im Automaten verwaltet */
    fileprivate var eierkartons: [Eierkarton]
    /** Das Monitorobjekt für dei Zugrtiffsregelung */
    fileprivate let monitor: NSCondition

    /**
    Besetzt die Attribute vor.
    */
    init()
    {
        monitor = NSCondition()
        eierkartons = [Eierkarton]()
        let automat = Rechteck()
        automat.GrößeSetzen(breite: 100, höhe: 200)
        automat.FarbeSetzen(farbe: "grau")
        automat.PositionSetzen(x: 350, y: 200)
        let dach = Dreieck()
        dach.GrößeSetzen(breite: 140, höhe: 50)
        dach.FarbeSetzen(farbe: "rot")
        dach.PositionSetzen(x: 400, y: 150)
    }

    /**
    Befüllen des Eierautomaten mit neuen Eierkartons
    */
    func Befüllen()
    {
        monitor.lock()
        if eierkartons.count == 0
        {
            // Der leere Automat wird mit zehn neuen Kartons befüllt.
            for zähler in 0 ..< 10
            {
                eierkartons.append(Eierkarton())
                eierkartons[zähler].PositionSetzen(x: 375, y: 205 + 20 * zähler)
            }
        }
        monitor.unlock()
    }

    /**
    Holen eines Eierkartons aus dem Automaten
     - returns: Eierkarton oder nil bei Fehlversuch
    */
    func EierHolen() -> Eierkarton?
    {
        monitor.lock()
        if eierkartons.count > 0
        {
            // Ein Eierkarton wird aus dem Feld entfernt und seine Darstellung aus dem Zeichenfenster
            let gekaufterKarton = eierkartons.remove(at: 0)
            gekaufterKarton.Entfernen()

            // Rückgabe des gekauften Kartons
            monitor.unlock()
            return gekaufterKarton
        }
        monitor.unlock()
        return nil
    }
}

/**
Leo, ein extremer Eierkonsument

- author: Johannes Neumeyer
- version: 1.0
 */
class Leo: Thread
{
    /** Zufallsgenertator zum Erzeugen einer zufälligen Wartezeit */
    var zufallsgenerator: Zufall
    /** Zähler für die Anzahl der Zugriffsversuche */
    var anzahlVersuche: Int
    /** Textanzeige */
    var ausgabeLeo: Text
    /** der zu verwendene Eierautomat */
    var automat: Eierautomat

    /**
    Konstruktor für Objekte der Klasse Leo
     - parameters:
        - eierautomat: der zu verwendene Eierautomat
    */
    init(eierautomat: Eierautomat)
    {
        automat = eierautomat
        zufallsgenerator = Zufall()
        ausgabeLeo = Text()
        ausgabeLeo.PositionSetzen(x: 550, y: 200)
        anzahlVersuche = 0
        super.init()
    }

    /**
    Leo versucht in unregelmäßigen Zeitabständen, einen Eierkarton aus dem Automaten zu holen.
    */
    override func main()
    {
        while true
        {
            // Textausgabe
            anzahlVersuche = anzahlVersuche + 1
            ausgabeLeo.TextSetzen(text: "\(anzahlVersuche). Eierholbesuch")
            
            // Eierholversuch
            automat.EierHolen()

            // Simulation der Zeitdauer zwischen zwei Eierholversuchen
            Thread.sleep(forTimeInterval: Double(zufallsgenerator.ZufallKomma()) * 0.2)
        }
    }
}

/**
Bäuerin, die einen Eierautomaten betreibt

- author: Johannes Neumeyer
- version: 1.0
*/
class Bäuerin: Thread
{
    /** Zufallsgenertator zum Erzeugen einer zufälligen Wartezeit */
    var zufallsgenerator: Zufall
    /** Zähler für die Anzahl der Zugriffsversuche */
    var anzahlVersuche: Int
    /** Textanzeige */
    var ausgabeBäuerin: Text
    /** der zu verwendene Eierautomat */
    var automat: Eierautomat

    /**
    Konstruktor für Objekte der Klasse Bäuerin
     - parameters:
        - eierautomat: der zu verwendene Eierautomat
    */
    init(eierautomat: Eierautomat)
    {
        automat = eierautomat;
        zufallsgenerator = Zufall()
        ausgabeBäuerin = Text()
        ausgabeBäuerin.PositionSetzen(x: 50, y: 200)
        anzahlVersuche = 0
    }

    /**
    Die Bäuerin versucht in unregelmäßigen Zeitabständen, den Eierautomaten wieder neu zu befüllen.
    */
    override func main()
    {
        while true
        {
            // Textausgabe
            anzahlVersuche = anzahlVersuche + 1
            ausgabeBäuerin.TextSetzen(text: "\(anzahlVersuche). Befüllbesuch");
            
            // Automatenbefüllversuch
            automat.Befüllen()

            Thread.sleep(forTimeInterval: Double(zufallsgenerator.ZufallKomma()) * 4.0)// Zufallszahl aus dem Bereich [0s; 4.0s[
        }
    }
}


/**
Besserer Eierautomat auf dem Lande

- author: Johannes Neumeyer
- version: 1.0
*/
class BessererEierautomat: Eierautomat
{
    /**
    Besetzt die Attribute vor.
    */
    override init()
    {
        super.init()
    }

    /**
    Befüllen des Eierautomaten mit neuen Eierkartons
     */
    override func Befüllen()
    {
        monitor.lock()
        // So lange der Automat noch Eierkartons enthält, muss mit dem Befüllen gewartet werden.
        while eierkartons.count > 0
        {
            monitor.wait()
        }

        // Der leere Automat wird mit zehn neuen Kartons befüllt.
        for zähler in 0 ..< 10
        {
            eierkartons.append(Eierkarton())
            eierkartons[zähler].PositionSetzen(x: 375, y: 205 + 20 * zähler)
        }

        // Der Zustand der Variable in der Wartebedingung hat sich verändert.
        // Ein wartender Thread wird benachrichtigt.
        monitor.signal()
        monitor.unlock()
    }

    /**
    Holen eines Eierkartons aus dem Automaten
     - returns: Eierkarton oder nil bei Fehlversuch
    */
    override func EierHolen() -> Eierkarton?
    {
        monitor.lock()
        // solange eine bestimmte Bedingung gilt, müssen Abholer abwarten
        // --- HIER PROGRAMMCODE ERGÄNZEN
        // --- HINWEIS: Die Bedingung um die folgenden Anweisungen könnte dann entfernt werden,
        // --- ebenso die Rückgabe der leeren Referenz.

        if eierkartons.count > 0
        {
            // Ein Eierkarton wird aus dem Feld entfernt und seine Darstellung aus dem Zeichenfenster
            let gekaufterKarton = eierkartons.remove(at: 0)
            gekaufterKarton.Entfernen()

            // Unter einer bestimmten Bedingung muss die Baeuerin informiert werden
            // --- HIER PROGRAMMCODE ERGÄNZEN

            // Rückgabe des gekauften Kartons
            monitor.signal()
            monitor.unlock()
            return gekaufterKarton
        }
        monitor.signal()
        monitor.unlock()
        return nil
    }
}


/**
Befüllen und Entleeren eines laendlichen Eierautomaten

- author: Johannes Neumeyer
- version: 1.0
*/
class Landleben
{

    /**
    Konstruktor für Objekte der Klasse Landleben
    */
    init()
    {
        let automat = Eierautomat()
        // let automat = BessererEierautomat()
        let b = Bäuerin(eierautomat: automat)
        let l = Leo(eierautomat: automat)
        b.start()
        l.start()
    }
}

Landleben()
