import Foundation

/**
Boot auf dem Chiemsee

- author: Johannes Neumeyer
- version: 1.0
 */
class Boot: Thread
{
    /** Id des Boots */
    var kennzeichen: Int
    /** verwaltet die Liegeplätze */
    var steg: Stegverwaltung
    /** Zufallsgenerator für die Fahr- und Liegezeiten */
    var zufallsgenerator: Zufall

    /**
    Konstruktor für Objekte der Klasse Boot
    - parameters:
        - kennzeichenNeu: Id des Boots
        - stegNeu: Verwaltung für dsen Steg
    */
    init(kennzeichenNeu: Int, stegNeu: Stegverwaltung)
    {
        kennzeichen = kennzeichenNeu
        steg = stegNeu
        zufallsgenerator = Zufall()
    }

    /**
    Ein Boot wiederholt folgende Aktionen:
    - zufällige Zeit auf dem See herumfahren
    - Platz am Steg reservieren
    - zufällige Zeit am Steg liegen
    - Platz wieder freigeben
    */
    override func main()
    {
        while true
        {
            /*
             * Damit der Fehler schnell entsteht, wurden die Wartezeiten jeweils auskommentiert
             */
            
            //Thread.sleep(forTimeInterval: Double(zufallsgenerator.ZufallKomma()) * 0.1)
            steg.PlatzReservieren(bootAn: self)

            //Thread.sleep(forTimeInterval: Double(zufallsgenerator.ZufallKomma()) * 0.3)   // liegen ...
            steg.PlatzFreigeben(bootAb: self)
        }
    }

    /**
    Liefert das Kennzeichen des Boots.
     - returns: Kennzeichen
    */
    func KennzeichenGeben() -> Int
    {
        return kennzeichen
    }
}


/**
Verwaltung eines Stegs am Chiemsee

- author: Johannes Neumeyer
- version: 1.0
*/
class Stegverwaltung
{
    /** Boote, die angelegt haben */
    var boote: [Boot]
    /** Anzahl der Boote, die angelegt haben */
    var bootanzahl: Int
    /** Hilfsvariable, die einen entstandenen Fehler anzeigt */
    var fehler: Bool
    
    /**
    Konstruktor für Objekte der Klasse Steg
    */
    init()
    {
        boote = [Boot]()
        bootanzahl = 0
        fehler = false
    }

    /**
    Ein Boot reserviert einen Liegeplatz.
    - parameters:
        - bootAn: das Boot, das anlegen will
    */
    func PlatzReservieren(bootAn: Boot)
    {
        while bootanzahl >= 10
        {
            
        }
        boote.append(bootAn)
        bootanzahl += 1
        
        if bootanzahl > 10
        {
            fehler = true
        }
        
        print("Boot \(bootAn.KennzeichenGeben()) angelegt --> Boote am Steg: \(bootanzahl)")
    }

    /**
    Ein Boot verlässt den Steg und gibt den Liegeplatz frei.
     - parameters:
         - bootAb: das Boot, das ablegen will
    */
    func PlatzFreigeben(bootAb: Boot)
    {
        boote.removeAll(where: {$0 === bootAb})
        bootanzahl -= 1
        
        if bootanzahl < 0
        {
            fehler = true
        }
        
        print("Boot \(bootAb.KennzeichenGeben()) abgelegt --> Boote am Steg: \(bootanzahl)")
    }
}


/**
Verwaltet alle Boote

- author: Johannes Neumeyer
- version: 1.0
*/
class Chiemsee
{
    /** Verwaltung der Liegeplätze */
    var steg: Stegverwaltung
    
    /**
    Konstruktor für Objekte der Klasse Chiemsee
    */
    init()
    {
        steg = Stegverwaltung()
        for i in 0 ..< 15
        {
            let boot = Boot(kennzeichenNeu: i, stegNeu: steg)
            boot.start()
        }
    }
}

Chiemsee()
