import Foundation

/**
Parkplatz

- author: Johannes Neumeyer
- version: 1.0
*/
class Parkplatz
{
    /** gibt an, ob der Parkplatz belegt ist oder nicht */
    private var frei: Bool

    /**
    Konstruktor für Objekte der Klasse Parkplatz
    */
    init()
    {
        frei = true
    }

    /**
    Falls der Parkplatz frei ist, wird er beparkt.
    - parameters:
        - kennzeichen: Kennzeichen des Fahrzeugs
    - returns: wahr, wenn der Platz beparkt werden konnte
    */
    func Beparken(kennzeichen: Int) -> Bool
    {
        if frei
        {
            frei = false
            print("\(kennzeichen) erfolgreich eingeparkt.")
            return true
        }
        print("Parkplatz belegt. Fahrzeug \(kennzeichen) fährt um den Block.")
        return false
    }

    /**
    Der Parkplatz wird verlassen.
     - parameters:
         - kennzeichen: Kennzeichen des Fahrzeugs
    */
    func Ausparken(kennzeichen: Int)
    {
        print("\(kennzeichen) ausgeparkt.")
        frei = true
    }
}

/**
Fahrzeug im Verkehr

- author: Johannes Neumeyer
- version: 1.0
*/
class Fahrzeug: Thread
{
    /** Id des Fahrzeugs */
    var kennzeichen: Int
    /** angestrebter Parkplatz */
    var zielParkplatz: Parkplatz

    /**
    Konstruktor für Objekte der Klasse Fahrzeug
     - parameters:
         - kennzeichenNeu: Kennzeichen des Fahrzeugs
         - parkplatz: der gewünschte Parkplatz
    */
    init(kennzeichenNeu: Int, parkplatz: Parkplatz)
    {
        kennzeichen = kennzeichenNeu
        zielParkplatz = parkplatz
    }

    /**
    Das Fahrzeug versucht permanent, den gewünschten Parkplatz zu belegen.
    Anschließend parkt es wieder aus und "fährt um den Block",
    um dann wieder von Neuem zu beginnen.
    */
    override func main()
     {
         while true
         {
             // Einparkversuch
             let eingeparkt = zielParkplatz.Beparken(kennzeichen: kennzeichen)
             // Der Parkplatz war frei.
             if eingeparkt
             {
                 // Parken
                 Thread.sleep(forTimeInterval: 2.5)
                 // Ausparken
                 zielParkplatz.Ausparken(kennzeichen: kennzeichen)
             }
             // Um den Block fahren
             Thread.sleep(forTimeInterval: 5.0)
         }
     }
 }

/**
Fahrzeuge, die um einen freien Parkplatz konkurrieren

- author: Johannes Neumeyer
- version 1.0
*/
class Parkverkehr
{
    /**
    Konstruktor für Objekte der Klasse Parkverkehr
    */
    init()
    {
        let p = Parkplatz()
                
        for id in 0 ..< 10
        {
            let f = Fahrzeug(kennzeichenNeu: id, parkplatz: p)
            f.start();
        }
    }
}

Parkverkehr()
