
import java.util.*;
/**
 * Ermittelt den Zeitbedarf, um alle Passwörter gegebener Länge und mit gegebenem Zeichenvorrat durchzuprobieren
 * 
 * @author Albert Wiedemann
 * @version 1.0
 */
class Passwoerter
{
    /** Das Passwort */
    String passwort;
    /** Der Zeichenvorrat */
    char[] zeichen;
    /** Die Startzeit der Suche */
    long start;
    

    /**
     * Besetzt die Attribute mit Default-Werten
     */
    Passwoerter()
    {
        passwort = "";
        zeichen = new char[0];
    }
    
    /**
     * Setzt alle Grossbuchstaben als Zeichenvorrat
     */
    private void Alphabet26Setzen()
    {
        zeichen = new char[26];
        char ch = 'A';
        for (int i = 0; i < 26; i += 1)
        {
            zeichen[i] = ch;
            ch += 1;
        }
    }
    
    /**
     * Setzt alle Buchstaben als Zeichenvorrat
     */
    private void Alphabet52Setzen()
    {
        zeichen = new char[52];
        char ch = 'A';
        for (int i = 0; i < 26; i += 1)
        {
            zeichen[i] = ch;
            ch += 1;
        }
        ch = 'a';
        for (int i = 26; i < 52; i += 1)
        {
            zeichen[i] = ch;
            ch += 1;
        }
    }
    
    /**
     * Setzt alle Buchstaben, Ziffern und genügend Sonderzeichen als Zeichenvorrat
     */
    private void Alphabet78Setzen()
    {
        zeichen = new char[78];
        char ch = 'A';
        for (int i = 0; i < 26; i += 1)
        {
            zeichen[i] = ch;
            ch += 1;
        }
        ch = 'a';
        for (int i = 26; i < 52; i += 1)
        {
            zeichen[i] = ch;
            ch += 1;
        }
        ch = '0';
        for (int i = 52; i < 62; i += 1)
        {
            zeichen[i] = ch;
            ch += 1;
        }
        ch = '!';
        for (int i = 63; i < 78; i += 1)
        {
            zeichen[i] = ch;
            ch += 1;
        }
    }
    
    /** 
     * Erzeugt ein Passwort gegebener Länge aus dem vorhandenen Zeichenvorrat.
     * @param stellenanzahl Anzahl der Stellen für das Passwort
     */
    private void PasswortErzeugen(int stellenanzahl)
    {
        Random zufall = new Random();
        passwort = "";
        for (int i = 0; i < stellenanzahl; i += 1)
        {
            passwort = passwort + zeichen[zufall.nextInt(zeichen.length)];
        }
    }
    
    /**
     * Bearbeitet eine Stelle
     * @param anfangsFolge die bisherige Zeichenfolge für den Passworttest
     */
    private void NächsteStelleTesten(String anfangsFolge)
    {
        for (char ch: zeichen)
        {
            String test = anfangsFolge + ch;
            if (passwort.length() == test.length())
            {
                if (passwort.equals(test))
                {
                    System.out.println("Gefunden nach: " + ((System.nanoTime() - start) / 1000) + "µs");
                }
            }
            else
            {
                NächsteStelleTesten(test);
            }
        }
    }
    
    /**
     * Testet alle Möglichkeiten für das Passwort durch
     * @param stellenanzahl Anzahl der Stellen für das Passwort
     * @param alphabetlänge Anzahl der Zeichen im Alphabet, erlaubt sind 26, 52 oder 78 Zeichen
     */
    void PasswortTest(int stellenanzahl, int alphabetlänge)
    {
        if (alphabetlänge == 26)
        {
            Alphabet26Setzen();
        }
        else if (alphabetlänge == 52)
        {
            Alphabet52Setzen();
        }
        else if (alphabetlänge == 78)
        {
            Alphabet78Setzen();
        }
        else
        {
            System.out.println("Falsche Alphabetlänge " + alphabetlänge);
        }
        PasswortErzeugen(stellenanzahl);
        start = System.nanoTime();
        NächsteStelleTesten("");
        System.out.println("Gesamtlaufzeit: " + ((System.nanoTime() - start) / 1000) + "µs");
    }
}
