
import java.util.*;
/**
 * Sucht im Graph nach dem Alorithmus von Dijkstra.
 * 
 * @author Albert Wiedemann 
 * @version 1.0
 */
class Dijkstra
{
    /** Adjazenzmatrix des Graphen */
    private int[][] matrix;
    /** Liste der abgearbeiteten Knoten */
    private ArrayList<Knoten> fertig;
    /** Liste der unbearbeiteten Knoten */
    private ArrayList<Knoten> rest;
    /** Liste der erreichten Knoten */
    private ArrayList<Knoten> inarbeit;

    /**
     * Legt die Hilfsdaten an.
     * @param m Adjazenzmatrix 
     */
    Dijkstra(int[][] m)
    {
        matrix = m;
        fertig = new ArrayList<Knoten>();
        rest = new ArrayList<Knoten>();
        inarbeit = new ArrayList<Knoten>();
    }

    /**
     * Führt die Suche aus.
     * @param von Startknoten
     * @param nach Zielknoten
     * @return Weglänge
     */
    int WegSuchen(int von, int nach)
    {
        int akt;
        int länge;
        for (int i = 0; i < matrix.length; i += 1)
        {
            if (i == von)
            {
                fertig.add(new Knoten(i));
            }
            else
            {
                inarbeit.add(new Knoten(i));
            }
        }
        akt = von;
        länge = 0;
        while (akt != nach)
        {
            for (int i = 0; i < matrix.length; i += 1)
            {
                if (matrix[akt][i] > 0)
                {
                    Knoten k = KnotenSuchen(rest, i);
                    if (k != null)
                    {
                        k.LängeSetzen (länge + matrix[akt][i]);
                        rest.remove(k);
                        inarbeit.add(k);
                    }
                    else
                    {
                        k = KnotenSuchen(inarbeit, i);
                        if (k != null)
                        {
                            if (länge + matrix[akt][i] < k.LängeGeben ())
                            {
                                k.LängeSetzen(länge + matrix[akt][i]);
                            }
                        }
                    }
                }
            }
            Knoten nächster = null;
            for (Knoten k: inarbeit)
            {
                if ((nächster == null) || (nächster.LängeGeben() > k.LängeGeben()))
                {
                    nächster = k;
                }
            }
            if (nächster == null)
            {
                return -1;
            }
            inarbeit.remove(nächster);
            fertig.add(nächster);
            länge = nächster.LängeGeben();
            akt = nächster.NummerGeben();
        }
        return länge;
    }
    
    /**
     * Sucht den Knoten mit der angegebenen Nummer
     * @param feld das Knotenfeld, in dem gesucht werden soll
     * @param nummer die Nummer des gesuchten Knotens
     * @return Knotenreferenz oder null, falls der Knoten mit der angegebenen Nummer nicht im Feld ist.
     */
    private Knoten KnotenSuchen(ArrayList<Knoten> feld, int nummer)
    {
        for (Knoten k: feld)
        {
            if (k.NummerGeben() == nummer)
            {
                return k;
            }
        }
        return null;
    }
}
