
import java.util.Random;
/**
 * Generiert den Graphen (Adjazenzmatrix).
 * 
 * @author Albert Wiedemann 
 * @version 1.0
 */
class Generieren
{
    /** Maximale Entfernung zweier Knoten */
    private final static int maxEntfernung = 100;
    /** Adjazenzmatrix */
    private int[][] matrix;
    /** Zufallsgenerator für die Weglängen */
    private Random zufall;

    /**
     * Legt die Felder an.
     * @param anzahl Anzahl der Knoten
     */
    Generieren(int anzahl)
    {
        matrix = new int[anzahl][anzahl];
        zufall = new Random();
    }
    
    /**
     * Generiert die Adjazenzmatrix.
     * Auf eine zweidimensionale Darstellbarkeit wird nicht geachtet.
     * @param anzahl Anzahl der zu generierenden Kanten;
     * @return Adjazenzmatrix
     */
    int[][] AdjazenzmatrixGenerieren(int anzahl)
    {
        int von, nach, weg;
        for (int i = 0; i < matrix.length; i += 1)
        {
            for (int j = 0; j < matrix[i].length; j += 1)
            {
                if (i == j)
                {
                    matrix[i][j] = 0;
                }
                else
                {
                    matrix[i][j] = -1;
                }
            }
            
        }
        for (int i = 0; i < anzahl; i += 1)
        {
            do
            {
                von = zufall.nextInt(matrix.length);
                nach = zufall.nextInt(matrix[0].length);
            }
            while (matrix[von][nach] >= 0);
            weg = zufall.nextInt(maxEntfernung);
            matrix[von][nach] = weg;
            matrix[nach][von] = weg;
        }
        return matrix;
    }
}
