
/**
 * Kontrolleur des Programms.
 * 
 * @author Albert Wiedemann
 * @version 1.0
 */
class Kontrolleur
{
    /** Die ereigniserzeugende Oberfläche */
    private Oberflaeche oberfläche;
    
    /**
     * Besetzt das Attribut vor.
     */
    Kontrolleur()
    {
        oberfläche = null;
    }

    /**
     * Setzt die Oberfläche.
     * @param o die ereigniserzeugende Oberfläche
     */
    void OberflächeSetzen(Oberflaeche o)
    {
        oberfläche = o;
    }

    /**
     * Ausführen der Laufzeitmessungen.
     * @param anzahlElemente Anzahl der Knoten im Graphen
     */
    void WegesucheAusführen(int anzahlElemente)
    {
        TestSuchen test;
        oberfläche.DijkstraSuchzeitSetzen("---");
        test = new TestSuchen(anzahlElemente);
        test.DurchschnittsTest();
        oberfläche.DijkstraSuchzeitSetzen("" + test.ZeitFürDijkstraGeben ());
    }
    
    /**
     * Beendet das Programm.
     */
    void BeendenAusführen()
    {
        System.exit(0);
    }
}
