

import java. awt. *;
import java. awt. event. *;
import javax. swing. *;
/**
 * Die Bedienoberfläche für den Laufzeittest.
 * 
 * @author Albert Wiedemann 
 * @version 1.0
 */
class Oberflaeche
{
    private JFrame fenster;
    private JTextField datenAnzahl;
    private JLabel suchzeitDijkstra;
    private JButton testen;
    private JButton beenden;
    private Kontrolleur kontrolleur;
    
    /**
     * Legt die Oberflächenelemente an und setzt den Kontrolleur.
     * @param kontrolleur der verwaltende Kontrolleur
     */
    Oberflaeche(Kontrolleur kontrolleur)
    {
        this.kontrolleur = kontrolleur;
        FensterAufbauen();
    }
    
    /**
     * Führt den Aufbau der Oberflächenelemente durch.
     */
    private void FensterAufbauen()
    {
        JPanel content;
        JPanel p;
        JLabel l;
        fenster = new JFrame ("Wegesuche mit Dijkstra testen");
        content = (JPanel) fenster.getContentPane();
        content. setLayout(new BorderLayout());
        p = new JPanel();
        content.add (p, BorderLayout.NORTH);
        p.setLayout(new GridLayout(3, 2));
        l = new JLabel("Anzahl der Knoten im Graph");
        p.add(l);
        datenAnzahl = new JTextField();
        p.add(datenAnzahl);
        l = new JLabel(" ");
        p.add(l);
        l = new JLabel(" ");
        p.add(l);
        l = new JLabel("Zeit für Wegesuche nach Dijkstra [ns]");
        p.add(l);
        suchzeitDijkstra = new JLabel("---");
        p.add(suchzeitDijkstra);
        
        p = new JPanel ();
        content.add(p, BorderLayout.SOUTH);
        p.setLayout (new FlowLayout());
        testen = new JButton ("Test ausführen");
        p.add(testen);
        testen.addActionListener(new ActionListener ()
        {
            public void actionPerformed(ActionEvent e)
            {
                try
                {
                    kontrolleur.WegesucheAusführen(Integer.parseInt(datenAnzahl.getText()));
                }
                catch (Exception ex)
                {
                    JOptionPane.showMessageDialog(fenster, "Bitte korrekte Zahlenwerte angeben" + ex +".", "Fehlermeldung", JOptionPane.ERROR_MESSAGE);
                    ex.printStackTrace();
                }
            }
        });
        beenden = new JButton("Beenden");
        p.add(beenden);
        beenden.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                kontrolleur.BeendenAusführen();
            }
        });
        
        fenster.setSize(new Dimension(800, 200));
        fenster.setMinimumSize(new Dimension(300, 200));
        fenster.setPreferredSize(new Dimension(800, 200));
        fenster.setVisible(true);        
    }
    
    /**
     * Trägt die Suchzeit für Wegesuche nach Dijkstra ein.
     * @param zeit benötigte Suchzeit
     */
    void DijkstraSuchzeitSetzen(String zeit)
    {
        suchzeitDijkstra.setText(zeit);
    }
}
