
import java. util. Random;
/**
 * Führt die gewünschten Laufzeittests durch.
 * 
 * @author Albert Wiedemann
 * @version 1.0
 */
class TestSuchen
{
    /** Anzahl der Datenelemente im Graphen */
    private int anzahl;
    /** Die Laufzeitsumme */
    private long zeitDijkstra;
    /** Die Adjazenzmatrix */
    private int[][] matrix;
    /** Startort */
    private int start;
    /** Zielort */
    private int ziel;

    /**
     * Legt die benötigten Objekte an und besetzt die Attributwerte.
     * @param anzahl Anzahl der Knoten im Graph
     */
    TestSuchen(int anzahl)
    {
        this.anzahl = anzahl;
        matrix = new Generieren(anzahl).AdjazenzmatrixGenerieren((anzahl - 1) * 2);
    }
   
    /**
     * Bestimmt die durschnittliche Zeit für die Knotenbesuche.
     */
    void DurchschnittsTest()
    {
        Random zufall;
        zufall = new Random();
        zeitDijkstra = 0;
        for (int i = 0; i < 1000; i += 1)
        {
            start = zufall.nextInt(anzahl);
            do
            {
                ziel = zufall.nextInt(anzahl);
            }
            while (start == ziel);
            Dijkstra t;
            t = new Dijkstra(matrix);
            long startZeit = System.nanoTime();
            t.WegSuchen(start, ziel);
            long endeZeit = System.nanoTime();
            zeitDijkstra += endeZeit - startZeit;
        }
        zeitDijkstra = zeitDijkstra /= 1000;
    }
    
    /**
     * Meldet die durchschnittliche Zeit für die Suche nach Dijkstra.
     * @return Suchzeit
     */
    long ZeitFürDijkstraGeben()
    {
        return zeitDijkstra;
    }
}
