package Baum;

/**
 * Ein sortierter Binärbaum nach Standardimplementierung.
 * 
 * @author Albert Wiedemann 
 * @version 1.0
 */
public class Baum
{
    /** Referenz auf die Wurzel des Baums. */
    private BaumElement anfang;

    /**
     * Legt einen leeren Baum an.
     */
    public Baum()
    {
        anfang = new Abschluss();
    }


    /**
     * Fügt ein neues Datenelement in den Baum ein.
     * @param neu das neue Datenelement
     */
    public void Einfügen(String neu)
    {
        anfang = anfang.Einfügen(neu);
    }
    
    /**
     * Sucht ein Datenelement mit dem in der Referenz angegebenen Schlüssel.
     * @param schlüssel der zu suchende Schlüsselwert
     * @return das gefundene Datenelement oder null
     */
    public String Suchen(String schlüssel)
    {
        return anfang.Suchen(schlüssel);
    }
}
