package Baum;

/**
 * Beschreibt ein abstraktes Element des Baums.
 * 
 * @author Albert Wiedemann 
 * @version 1.0
 */
abstract class BaumElement
{
    
    /**
     * Fügt ein neues Datenelement sortiert in den Baum ein.
     * @param neu das neue Datenelement
     * @return der (neue) Nachfolger für das Vorgängerelement
     */
    abstract BaumElement Einfügen(String neu);
    
    /**
     * Sucht ein Datenelement mit dem angegebenen Schlüssel.
     * @param schlüssel der zu suchende Schlüsselwert
     * @return das gefundene Datenelement oder null
     */
    abstract String Suchen(String schlüssel);

}
