package Baum;

/**
 * Beschreibt einen Knoten des Baums.
 * 
 * @author Albert Wiedemann
 * @version 1.0
 */
class Knoten extends BaumElement
{
    /** das Datenelement */
    private String daten;
    /** Referenz auf den linken Nachfolgerknoten (mit den kleineren Werten) */
    private BaumElement linksnachfolger;
    /** Referenz auf den rechten Nachfolgerknoten (mit den größeren Werten) */
    private BaumElement rechtsnachfolger;
    
    /**
     * Legt einen neuen Knoten mit gegebenem Datenelement und gegebenen Nachfolgern an.
     * @param d das von diesem Knoten verwaltete Datenelement
     * @param lnf Referenz auf das linke Nachfolgerelement
     * @param rnf Referenz auf das rechte Nachfolgerelement
     */
    Knoten(String d, BaumElement lnf, BaumElement rnf)
    {
        daten = d;
        linksnachfolger = lnf;
        rechtsnachfolger = rnf;
    }
    
    /**
     * Fügt ein neues Datenelement sortiert in den Baum ein.
     * @param neu das neue Datenelement
     * @return der (neue) Nachfolger für das Vorgängerelement
     */
    BaumElement Einfügen(String neu)
    {
        if (neu.compareTo(daten) > 0)
        {
            rechtsnachfolger = rechtsnachfolger.Einfügen(neu);
        }
        else
        {
            linksnachfolger = linksnachfolger.Einfügen(neu);
        }
        return this;
    }
    
    /**
     * Sucht ein Datenelement mit dem angegebenen Schlüssel.
     * @param schlüssel der zu suchende Schlüsselwert
     * @return das gefundene Datenelement oder null
     */
    String Suchen(String schlüssel)
    {
        int vergleich;
        vergleich = schlüssel.compareTo(daten);
        if (vergleich == 0)
        {
            return daten;
        }
        else if (vergleich < 0)
        {
            return linksnachfolger.Suchen(schlüssel);
        }
        else
        {
            return rechtsnachfolger.Suchen(schlüssel);
        }
    }
}
