
/**
 * Kontrolleur des Programms.
 * 
 * @author Albert Wiedemann
 * @version 1.0
 */
class Kontrolleur
{
    /** Die ereigniserzeugende Oberfläche */
    private Oberflaeche oberfläche;
    
    /**
     * Besetzt das Attribut vor.
     */
    Kontrolleur()
    {
        oberfläche = null;
    }

    /**
     * Setzt die Oberfläche.
     * @param o die ereigniserzeugende Oberfläche
     */
    void OberflächeSetzen(Oberflaeche o)
    {
        oberfläche = o;
    }
    
    /**
     * Ausführen der Laufzeitmessungen.
     * @param anzahlElement Anzahl der Datenelemente in Liste bzw. Baum
     * @param liste gibt an, ob in der Liste gesucht werden soll
     * @param baum gibt an, ob im Baum gesucht werden soll
     */
    void SuchenAusführen(int anzahlElemente)
    {
        TestSuche test;
        oberfläche.ListenSuchzeitSetzen("---");
        oberfläche.BaumSuchzeitSetzen("---");
        test = new TestSuche(anzahlElemente);
        test.DurchschnittsTest();
        oberfläche.ListenSuchzeitSetzen("" + test.ZeitFürListensucheGeben ());
        oberfläche.BaumSuchzeitSetzen("" + test.ZeitFürBaumsucheGeben ());
    }
    
    /**
     * Beendet das Programm.
     */
    void BeendenAusführen()
    {
        System.exit(0);
    }
}
