package Liste;

/**
 * Beschreibt einen Knoten der Liste.
 * 
 * @author Albert Wiedemann
 * @version 1.0
 */
class Knoten extends ListenElement
{

    /** Referenz auf das Datenelement */
    private String daten;
    /** Referenz auf den Nachfolgerknoten */
    private ListenElement nachfolger;
    
    /**
     * Legt einen neuen Knoten mit gegebenem Datenelement und gegebenem Nachfolger an.
     * @param d das von diesem Knoten verwaltete Datenelement
     * @param nf Referenz auf das Nachfolgerelement
     */
    Knoten(String d, ListenElement nf)
    {
        daten = d;
        nachfolger = nf;
    }
    
    /**
     * Fügt ein neues Datenelement sortiert in die Liste ein.
     * @param neu das neue Datenelement
     * @return der (neue) Nachfolger für das Vorgängerelement
     */
    @Override ListenElement Einfügen(String neu)
    {
        if (neu.compareTo(daten) > 0)
        {
            nachfolger = nachfolger.Einfügen(neu);
            return this;
        }
        else
        {
            return new Knoten(neu, this);
        }
    }

    /**
     * Sucht ein Datenelement mit dem in der Referenz angegebenen Schlüssel.
     * @param schlüssel der zu suchende Schlüsselwert
     * @return das gefundene Datenelement oder null
     */
    @Override String Suchen(String schlüssel)
    {
        if (schlüssel.compareTo(daten) == 0)
        {
            return daten;
        }
        else
        {
            return nachfolger.Suchen(schlüssel);
        }
    }
}
