package Liste;

/**
 * Beschreibt ein abstraktes Element der Liste.
 * 
 * @author Albert Wiedemann 
 * @version 1.0
 */
abstract class ListenElement
{

    /**
     * Keine Aufgabe, nur zur Dokumentation aufgeführt.
     */
    ListenElement()
    {
        
    }
    
    /**
     * Fügt ein neues Datenelement sortiert in die Liste ein.
     * @param neu das neue Datenelement
     * @return der (neue) Nachfolger für das Vorgängerelement
     */
    abstract ListenElement Einfügen(String neu);
    
    /**
     * Sucht ein Datenelement mit dem in der Referenz angegebenen Schlüssel.
     * @param schlüssel der zu suchende Schlüsselwert
     * @return das gefundene Datenelement oder null
     */
    abstract String Suchen(String schlüssel);
}
