
import java. awt. *;
import java. awt. event. *;
import javax. swing. *;
/**
 * Die Bedienoberfläche für den Laufzeittest.
 * 
 * @author Albert Wiedemann 
 * @version 1.0
 */
class Oberflaeche
{
    private JFrame fenster;
    private JTextField datenAnzahl;
    private JLabel suchzeitListe;
    private JLabel suchzeitBaum;
    private JButton testen;
    private JButton beenden;
    private Kontrolleur kontrolleur;
    
    /**
     * Legt die Oberflächenelemente an und setzt den Kontrolleur.
     * @param kontrolleur der verwaltende Kontrolleur
     */
    Oberflaeche(Kontrolleur kontrolleur)
    {
        this.kontrolleur = kontrolleur;
        FensterAufbauen();
    }
    
    /**
     * Führt den Aufbau der Oberflächenelemente durch.
     */
    private void FensterAufbauen()
    {
        JPanel content;
        JPanel p;
        JLabel l;
        fenster = new JFrame("Suchmethoden testen");
        content = (JPanel) fenster.getContentPane();
        content. setLayout(new BorderLayout());
        p = new JPanel();
        content.add(p, BorderLayout.NORTH);
        p.setLayout (new GridLayout(4, 2));
        l = new JLabel("Anzahl der Datenelemente in der Liste bzw. im Baum");
        p.add(l);
        datenAnzahl = new JTextField();
        p.add(datenAnzahl);
        l = new JLabel(" ");
        p.add(l);
        l = new JLabel(" ");
        p.add(l);
        l = new JLabel("Mittlere Suchzeit in der Liste [Nanosekunden]");
        p.add(l);
        suchzeitListe = new JLabel("---");
        p.add(suchzeitListe);
        l = new JLabel("Mittlere Suchzeit im Baum [Nanosekunden]");
        p.add(l);
        suchzeitBaum = new JLabel("---");
        p.add(suchzeitBaum);
        
        p = new JPanel();
        content.add(p, BorderLayout.SOUTH);
        p.setLayout (new FlowLayout());
        testen = new JButton("Test ausführen");
        p.add(testen);
        testen.addActionListener (new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                    try
                    {
                        kontrolleur.SuchenAusführen(Integer.parseInt(datenAnzahl.getText ()));
                    }
                    catch (Exception ex)
                    {
                        JOptionPane.showMessageDialog(fenster, "Bitte korrekte Zahlenwerte angeben.", "Fehlermeldung", JOptionPane.ERROR_MESSAGE);
                    }
           }
        });
        beenden = new JButton("Beenden");
        p.add(beenden);
        beenden.addActionListener(new ActionListener ()
        {
            public void actionPerformed(ActionEvent e)
            {
                kontrolleur.BeendenAusführen();
            }
        });
        
        fenster.setSize (new Dimension(700, 200));
        fenster.setMinimumSize(new Dimension(300, 200));
        fenster.setPreferredSize(new Dimension(700, 200));
        fenster.setVisible(true);        
    }
    
    /**
     * Trägt die Suchzeit für die Suche in der Liste ein.
     * @param zeit benötigte Suchzeit
     */
    void ListenSuchzeitSetzen(String zeit)
    {
        suchzeitListe.setText(zeit);
    }
    
    /**
     * Trägt die Suchzeit für die Suche im Baum ein.
     * @param zeit benötigte Suchzeit
     */
    void BaumSuchzeitSetzen(String zeit)
    {
        suchzeitBaum.setText(zeit);
    }
}
