
import java. util. *;
/**
 * Führt die gewünschten Laufzeittests durch.
 * 
 * @author Albert Wiedemann
 * @version 1.0
 */
class TestSuche
{
    /** Anzahl der Datenelemente in Liste und / oder Baum */
    private int anzahl;
    /** Die zu testende Liste */
    private Liste.Liste l;
    /** Der zu testende Baum */
    private Baum.Baum b;
    /** Erzeugerelement für die Schlüsselwerte */
    private Generator g;
    /** Der Zufallsgeneratur für die Auswahl der zu suchenden Werte */
    private Random zufall;
    /** Die Laufzeitsummen */
    private long summe1, summe2;
    /** Die vorhandenen Datenelemente */
    private ArrayList<String> schlüsselwerte;

    /**
     * Legt die benötigten Objekte an und besetzt die Attributwerte.
     * @param anzahl Anzahl der Datenelemente in Liste und / oder Baum
     */
    TestSuche(int anzahl)
    {
        this.anzahl = anzahl;
        zufall = new Random();
        l = new Liste.Liste();
        b = new Baum.Baum();
        g = new Generator(10);
        schlüsselwerte = new ArrayList<String>();
        for (int i = 1; i <= anzahl; i += 1)
        {
            schlüsselwerte.add(g.BezeichnerGenerieren());
        }
    }
    
    /**
     * Zu suchendes Testelement auswählen.
     * @return Testelement
     */
    private String TestWählen()
    {
        return schlüsselwerte.get(zufall.nextInt(anzahl));
    }
    
    /**
     * Misst die Zeit für einen Suchvorgang in der Liste.
     * @param d das zu suchende Datenelement
     * @return die benötigte Suchzeit
     */
    private long ZeitFürListenSucheMessen(String d)
    {
        long start, ende;
        start = System.nanoTime();
        l.Suchen(d);
        ende = System.nanoTime();
        return ende - start;
    }
    
    /**
     * Misst die Zeit für einen Suchvorgang im Baum.
     * @param d das zu suchende Datenelement
     * @return die benötigte Suchzeit
     */
    private long ZeitFürBaumSucheMessen(String d)
    {
        long start, ende;
        start = System.nanoTime();
        b.Suchen(d);
        ende = System.nanoTime();
        return ende - start;
    }
    
    /**
     * Bestimmt die durschnittlichen Suchzeiten.
     * Es werden 5000 Suchvoränge ausgeführt, um einen angemessenen Durchschnitt zu erhalten
     */
    void DurchschnittsTest()
    {
        for (String d: schlüsselwerte)
        {
            l.Einfügen(d);
            b.Einfügen(d);
        }
        summe1 = 0;
        summe2 = 0;
        for (int i = 1; i <= 5000; i += 1)
        {
            String d = TestWählen();
            summe1 += ZeitFürListenSucheMessen(d);
            summe2 += ZeitFürBaumSucheMessen(d);
        }
        summe1 /= 5000;
        summe2 /= 5000;
    }
    
    /**
     * Meldet die durchschnittliche Zeit für die Suche in der Liste.
     * @return Suchzeit
     */
    long ZeitFürListensucheGeben()
    {
        return summe1;
    }
    
    /**
     * Meldet die durchschnittliche Zeit für die Suche im Baum.
     * @return Suchzeit
     */
    long ZeitFürBaumsucheGeben()
    {
        return summe2;
    }
}
