
import java. util. *;
/**
 * Führt die gewünschten Laufzeittests durch.
 * 
 * @author Albert Wiedemann
 * @version 1.0
 */
class TestSuche
{
    /** Anzahl der Suchvorgänge für die Durchschnittsbildung */
    private final int anzahlSuchvorgänge = 100000;
    /** Erzeugerelement für die Schlüsselwerte */
    private Generator g;
    /** Der Zufallsgeneratur für die Auswahl der zu suchenden Werte */
    private Random zufall;
    /** Die vorhandenen Datenelemente unsortiert */
    private ArrayList<String> schlüsselwerte;
    /** Die vorhandenen Datenelemente sortiert */
    private ArrayList<String> sortierteSchlüsselwerte;

    /**
     * Legt die benötigten Objekte an und besetzt die Attributwerte.
     */
    TestSuche()
    {
        zufall = new Random();
        g = new Generator(10);
        schlüsselwerte = new ArrayList<String>();
        sortierteSchlüsselwerte = new ArrayList<String>();
    }
    
    /**
     * Besetzt die Felder mit der gewünschten Anzahl von Elementen
     * @param anzahl Anzahl der Datenelemente
     */
    private void DatenErzeugen(int anzahl)
    {
        schlüsselwerte.clear();
        sortierteSchlüsselwerte.clear();
        for (int i = 0; i < anzahl; i += 1)
        {
            String neu = g.BezeichnerGenerieren();
            schlüsselwerte.add(neu);
            if (i == 0)
            {
                sortierteSchlüsselwerte.add(neu);
            }
            else
            {
                int pos = i;
                while ((pos > 0) && (sortierteSchlüsselwerte.get(pos - 1).compareTo(neu) > 0))
                {
                    pos -= 1;
                }
                sortierteSchlüsselwerte.add(pos, neu);
            }
        }
    }
    
    /**
     * Zu suchendes Testelement auswählen.
     * @return Testelement
     */
    private String TestWählen()
    {
        return schlüsselwerte.get(zufall.nextInt(schlüsselwerte.size()));
    }
    
    /**
     * Misst die Zeit für einen Suchvorgang im unsortierten Feld.
     * Um dem Mittelwert nahe zu kommen,wird der Vorgang 'anzahlSuchvorgänge' Mal
     * wiederholt und die durchschnittliche Suchzeit ermittelt.
     */
    private void UnsortierteSucheDurchführen()
    {
        long start, ende, zeit;
        int zähler, zählergesamt;
        int pos;
        zeit = 0;
        zählergesamt = 0;
        for (int i = 1; i <= anzahlSuchvorgänge; i += 1)
        {
            String gesucht = TestWählen();
            start = System.nanoTime();
            pos = 0;
            zähler = 0;
            while ((pos < schlüsselwerte.size()) && !schlüsselwerte.get(pos).equals(gesucht))
            {
                zähler += 1;
                pos += 1;
            }
            ende = System.nanoTime();
            zeit += ende - start;
            zählergesamt += zähler;
        }
        System.out.print("" + zeit / anzahlSuchvorgänge + "µs, " + zählergesamt / anzahlSuchvorgänge);
    }
    
    /**
     * Misst die Zeit für einen Suchvorgang im sortierten Feld.
     * Um dem Mittelwert nahe zu kommen,wird der Vorgang 'anzahlSuchvorgänge' Mal
     * wiederholt und die durchschnittliche Suchzeit ermittelt.
     */
    private void SortierteSucheDurchführen()
    {
        long start, ende, zeit;
        zeit = 0;
        for (int i = 1; i <= anzahlSuchvorgänge; i += 1)
        {
            String gesucht = TestWählen();
            start = System.nanoTime();
            int min = 0;
            int max = sortierteSchlüsselwerte.size();
            while (true)
            {
                int mitte = (max + min) / 2;
                int res = sortierteSchlüsselwerte.get(mitte).compareTo(gesucht);
                if (res == 0)
                {
                    break;
                }
                else if (res < 0)
                {
                    min = mitte + 1;
                }
                else
                {
                    max = mitte;
                }
                if (min >= max)
                {
                    break;
                }
            }
            ende = System.nanoTime();
            zeit += ende - start;
        }
        System.out.print("" + zeit / anzahlSuchvorgänge + "µs");
    }
    
    /**
     * Bestimmt die durschnittlichen Suchzeiten.
     * @param anzahl Anzahl der Feldelemente
     */
    void DurchschnittsTest(int anzahl)
    {
        DatenErzeugen(anzahl);
        System.out.print("Suche im unsortierten Feld mit " + anzahl + " Elementen: ");
        UnsortierteSucheDurchführen();
        System.out.println();
        System.out.print("Suche im sortierten Feld mit " + anzahl + " Elementen: ");
        SortierteSucheDurchführen();
        System.out.println();
    }
}
