
/**
 * Kontrolleur des Programms.
 * 
 * @author Albert Wiedemann
 * @version 1.0
 */
class Kontrolleur
{
    /** Die ereigniserzeugende Oberfläche */
    private Oberflaeche oberfläche;
    
    /**
     * Besetzt das Attribut vor.
     */
    Kontrolleur()
    {
        oberfläche = null;
    }

    /**
     * Setzt die Oberfläche.
     * @param o die ereigniserzeugende Oberfläche
     */
    void OberflächeSetzen (Oberflaeche o)
    {
        oberfläche = o;
    }
    
    /**
     * Ausführen der Zählermessungen.
     * @param anzahlElemente Anzahl der zu sortierenden Datenelemente
     */
    void SortierenAusführen(int anzahlElemente)
    {
        TestSortieren test;
        oberfläche.SelectionSortZählerSetzen("---");
        oberfläche.BubbleSortZählerSetzen("---");
        oberfläche.MergeSortZählerSetzen("---");
        test = new TestSortieren(anzahlElemente);
        oberfläche.SelectionSortZählerSetzen("" + test.ZählerFürSelectionSortGeben());
        oberfläche.BubbleSortZählerSetzen("" + test.ZählerFürBubbleSortGeben());
        oberfläche.MergeSortZählerSetzen("" + test.ZählerFürMergesortGeben());
        
    }
    
    /**
     * Beendet das Programm.
     */
    void BeendenAusfuehren()
    {
        System.exit(0);
    }
}
