
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * Die Bedienoberfläche für den Laufzeittest.
 * 
 * @author Albert Wiedemann 
 * @version 1.0
 */
class Oberflaeche
{
    private JFrame fenster;
    private JTextField datenAnzahl;
    private JLabel anzahlAuswahl;
    private JLabel anzahlVertauschen;
    private JLabel anzahlMischen;
    private JButton testen;
    private JButton beenden;
    private Kontrolleur kontrolleur;
    
    /**
     * Legt die Oberflächenelemente an und setzt den Kontrolleur.
     * @param kontrolleur der verwaltende Kontrolleur
     */
    Oberflaeche(Kontrolleur kontrolleur)
    {
        this.kontrolleur = kontrolleur;
        FensterAufbauen();
    }
    
    /**
     * Führt den Aufbau der Oberflächenelemente durch.
     */
    private void FensterAufbauen()
    {
        JPanel content;
        JPanel p;
        JLabel l;
        fenster = new JFrame("Sortiermethoden testen");
        content = (JPanel) fenster.getContentPane();
        content.setLayout (new BorderLayout());
        p = new JPanel();
        content. add (p, BorderLayout. NORTH);
        p.setLayout (new GridLayout(5, 2));
        l = new JLabel("Anzahl der zu sortierenden Datenelemente");
        p.add(l);
        datenAnzahl = new JTextField();
        p.add(datenAnzahl);
        l = new JLabel(" ");
        p.add(l);
        l = new JLabel(" ");
        p.add(l);
        l = new JLabel("Zähler für Sortieren durch Auswählen");
        p.add(l);
        anzahlAuswahl = new JLabel("---");
        p.add(anzahlAuswahl);
        l = new JLabel("Zähler für Sortieren durch Vertauschen");
        p.add(l);
        anzahlVertauschen = new JLabel("---");
        p.add(anzahlVertauschen);
        l = new JLabel("Zähler für Sortieren durch Mischen");
        p.add(l);
        anzahlMischen = new JLabel("---");
        p.add(anzahlMischen);
        
        p = new JPanel();
        content.add(p, BorderLayout.SOUTH);
        p.setLayout (new FlowLayout());
        testen = new JButton("Test ausführen");
        p.add(testen);
        testen.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                try
                {
                    kontrolleur.SortierenAusführen (Integer.parseInt(datenAnzahl.getText()));
                }
                catch (Exception ex)
                {
                    JOptionPane.showMessageDialog(fenster, "Bitte korrekte Zahlenwerte angeben.", "Fehlermeldung", JOptionPane.ERROR_MESSAGE);
                }
            }
        });
        beenden = new JButton("Beenden");
        p.add(beenden);
        beenden.addActionListener (new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                kontrolleur.BeendenAusfuehren();
            }
        });
        
        fenster.setSize(new Dimension(800, 200));
        fenster.setMinimumSize(new Dimension(300, 200));
        fenster.setPreferredSize(new Dimension(800, 200));
        fenster.setVisible(true);        
    }
    
    /**
     * Trägt die Anzahl der relevanten Operationen für Sortieren durch Auswählen ein.
     * @param anzahl Anzahl der Operationen
     */
    void SelectionSortZählerSetzen(String anzahl)
    {
        anzahlAuswahl.setText(anzahl);
    }
    
    /**
     * Trägt die Anzahl der relevanten Operationen für Sortieren durch Vertauschen ein.
     * @param anzahl Anzahl der Operationen
     */
    void BubbleSortZählerSetzen(String anzahl)
    {
        anzahlVertauschen.setText(anzahl);
    }
    
    /**
     * Trägt die Anzahl der relevanten Operationen für Sortieren durch Mischen ein.
     * @param anzahl Anzahl der Operationen
     */
    void MergeSortZählerSetzen(String zeit)
    {
        anzahlMischen.setText(zeit);
    }
}
