
/**
 * Führt die gewünschten Laufzeittests durch.
 * 
 * @author Albert Wiedemann
 * @version 1.0
 */
class TestSortieren
{
    /** Anzahl der Datenelemente im Feld */
    private int anzahl;
    /** Erzeugerelement für die Schlüsselwerte */
    private Generator g;
    /** Die Ausgangsdaten */
    private String[] daten;
    /** Die Zähler für die relevanten Operationen */
    // Hier die Attribute ergänzen

    /**
     * Legt die benötigten Objekte an und besetzt die Attributwerte.
     * @param anzahl Anzahl der zu sortierenden Datenelemente
     */
    TestSortieren(int anzahl)
    {
        this.anzahl = anzahl;
        g = new Generator(10);
        daten = new String[anzahl];
        for (int i = 0; i < anzahl; i += 1)
        {
            daten[i] = g.BezeichnerGenerieren();
        }
        String[] d = daten.clone();
        SelectionSort(d);
        d = daten.clone();
        BubbleSort(d);
        d = daten.clone();
        MergeSort(d);
    }

    /**
     * Sortiert das gegebene Feld durch Auswahl des jeweils kleinsten Elements im unsortierten Rest.
     * @param d das zu sortierende Feld
     */
    private void SelectionSort(String[] d)
    {
        int pos;
        String hilf;
        for (int i = 0; i < d.length - 1; i += 1)
        {
            pos = i;
            for (int j = i + 1; j < d.length; j++)
            {
                if (d[j].compareTo(d[pos]) < 0)
                {
                    pos = j;
                }
            }
            hilf = d[i];
            d[i] = d[pos];
            d[pos] = hilf;
        }
    }

    /**
     * Sortiert das gegebene Feld durch Vertauschen falsch stehender Nachbarelemente.
     * @param d das zu sortierende Feld
     */
    private void BubbleSort(String[] d)
    {
        String hilf;
        for (int i = 0; i < d.length; i += 1)
        {
            for (int j = 0; j < d.length - 1; j += 1)
            {
                if (d[j].compareTo(d[j + 1]) > 0)
                {
                    hilf = d[j];
                    d[j] = d[j + 1];
                    d[j + 1] = hilf;
                }
            }
        }
    }

    /**
     * Sortiert den angegebenen Teilbereich des Feldes.
     * pre: beide Felder enthalten die Ausgangsdaten, da der Start nicht vorhersagbar ist.
     * @param von das Feld mit den Ausgangsdaten
     * @param nach das Feld mit den Zieldaten
     * @param minIndex der Index, ab dem sortiert werden soll
     * @param topIndex der Index, bis zu dem (ausschließlich) sortiert werden soll
     */
    private void Mischen(String[] von, String[] nach, int minIndex, int topIndex)
    {
        /** Trenner in die zwei Teilfelder */
        int mitte;
        /** aktuelle Position im Zielfeld */
        int pos;
        /** aktuelle Position im unteren Ausgangsfeld */
        int posUnten;
        /** aktuelle Position im oberen Ausgangsfeld */
        int posOben;
        if (minIndex < topIndex - 1)
        {
            mitte = (minIndex + topIndex) / 2;
            Mischen(nach, von, minIndex, mitte);
            Mischen(nach, von, mitte, topIndex);
            posUnten = minIndex;
            posOben = mitte;
            pos = minIndex;
            while (pos < topIndex)
            {
                if (posUnten >= mitte)
                {
                    while (posOben < topIndex)
                    {
                        nach[pos] = von[posOben];
                        pos += 1;
                        posOben += 1;
                    }
                }
                else if (posOben >= topIndex)
                {
                    while (posUnten < mitte)
                    {
                        nach[pos] = von[posUnten];
                        pos += 1;
                        posUnten += 1;
                    }
                }
                else
                {
                    if (von[posUnten].compareTo(von[posOben]) <= 0)
                    {
                        nach[pos] = von[posUnten];
                        posUnten += 1;
                    }
                    else
                    {
                        nach[pos] = von[posOben];
                        posOben += 1;
                    }
                    pos += 1;
                }
            }
        }
    }
    
    /**
     * Sortiert das gegebene Feld durch Mischen immer längerer Teilfelder.
     * @param d das zu sortierende Feld
     */
    private void MergeSort(String[] d)
    {
        String[] nach;
        nach = d.clone();
        Mischen(d, nach, 0, d.length);
        for (int i = 0; i < d.length; i += 1)
        {
            d[i] = nach[i];
        }
    }
    
    /**
     * Meldet die Anzahl relevanter Operationen für die Sortierung durch direktes Auswählen.
     * @return Anzahl der Operationen
     */
    int ZählerFürSelectionSortGeben()
    {
        //Hier Zählerwert ausgeben
        return 0;
    }
    
    /**
     * Meldet die Anzahl relevanter Operationen für die Sortierung durch Vertauschen falsch stehender Nachbarelemente.
     * @return Anzahl der Operationen
     */
    int ZählerFürBubbleSortGeben()
    {
        //Hier Zählerwert ausgeben
        return 0;
    }
    
    /**
     * Meldet die Anzahl relevanter Operationen für die Sortierung durch Mischen.
     * @return Anzahl der Operationen
     */
    int ZählerFürMergesortGeben()
    {
        //Hier Zählerwert ausgeben
        return 0;
    }
}
