
/**
 * Kontrolleur des Programms.
 * 
 * @author Albert Wiedemann
 * @version 1.0
 */
class Kontrolleur
{
    /** Die ereigniserzeugende Oberfläche */
    private Oberflaeche oberfläche;
    
    /**
     * Besetzt das Attribut vor.
     */
    Kontrolleur()
    {
        oberfläche = null;
    }

    /**
     * Setzt die Oberfläche.
     * @param o die ereigniserzeugende Oberfläche
     */
    void OberflächeSetzen (Oberflaeche o)
    {
        oberfläche = o;
    }
    
    /**
     * Ausführen der Zählermessungen.
     * @param anzahlElemente Anzahl der zu sortierenden Datenelemente
     */
    void SortierenAusführen(int anzahlElemente)
    {
        TestSortieren test;
        oberfläche.BubbleSortZählerSetzen("---");
        oberfläche.ShakerSortZählerSetzen("---");
        test = new TestSortieren(anzahlElemente);
        oberfläche.BubbleSortZählerSetzen("" + test.ZählerFürBubbleSortGeben());
        oberfläche.ShakerSortZählerSetzen("" + test.ZählerFürShakerSortGeben());
        
    }
    
    /**
     * Beendet das Programm.
     */
    void BeendenAusfuehren()
    {
        System.exit(0);
    }
}
