
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * Die Bedienoberfläche für den Laufzeittest.
 * 
 * @author Albert Wiedemann 
 * @version 1.0
 */
class Oberflaeche
{
    private JFrame fenster;
    private JTextField datenAnzahl;
    private JLabel anzahlBubble;
    private JLabel anzahlShaker;
    private JButton testen;
    private JButton beenden;
    private Kontrolleur kontrolleur;
    
    /**
     * Legt die Oberflächenelemente an und setzt den Kontrolleur.
     * @param kontrolleur der verwaltende Kontrolleur
     */
    Oberflaeche(Kontrolleur kontrolleur)
    {
        this.kontrolleur = kontrolleur;
        FensterAufbauen();
    }
    
    /**
     * Führt den Aufbau der Oberflächenelemente durch.
     */
    private void FensterAufbauen()
    {
        JPanel content;
        JPanel p;
        JLabel l;
        fenster = new JFrame("Sortiermethoden testen");
        content = (JPanel) fenster.getContentPane();
        content.setLayout (new BorderLayout());
        p = new JPanel();
        content. add (p, BorderLayout. NORTH);
        p.setLayout (new GridLayout(4, 2));
        l = new JLabel("Anzahl der zu sortierenden Datenelemente");
        p.add(l);
        datenAnzahl = new JTextField();
        p.add(datenAnzahl);
        l = new JLabel(" ");
        p.add(l);
        l = new JLabel(" ");
        p.add(l);
        l = new JLabel("Zähler für Sortieren durch BubbleSort");
        p.add(l);
        anzahlBubble = new JLabel("---");
        p.add(anzahlBubble);
        l = new JLabel("Zähler für Sortieren durch ShakerSort");
        p.add(l);
        anzahlShaker = new JLabel("---");
        p.add(anzahlShaker);
        
        p = new JPanel();
        content.add(p, BorderLayout.SOUTH);
        p.setLayout (new FlowLayout());
        testen = new JButton("Test ausführen");
        p.add(testen);
        testen.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                try
                {
                    kontrolleur.SortierenAusführen (Integer.parseInt(datenAnzahl.getText()));
                }
                catch (Exception ex)
                {
                    JOptionPane.showMessageDialog(fenster, "Bitte korrekte Zahlenwerte angeben.", "Fehlermeldung", JOptionPane.ERROR_MESSAGE);
                }
            }
        });
        beenden = new JButton("Beenden");
        p.add(beenden);
        beenden.addActionListener (new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                kontrolleur.BeendenAusfuehren();
            }
        });
        
        fenster.setSize(new Dimension(800, 200));
        fenster.setMinimumSize(new Dimension(300, 200));
        fenster.setPreferredSize(new Dimension(800, 200));
        fenster.setVisible(true);        
    }
    
    /**
     * Trägt die Anzahl der relevanten Operationen für Sortieren durch Vertauschen ein.
     * @param anzahl Anzahl der Operationen
     */
    void BubbleSortZählerSetzen(String anzahl)
    {
        anzahlBubble.setText(anzahl);
    }
    
    /**
     * Trägt die Anzahl der relevanten Operationen für Sortieren durch Vertauschen hin und her ein.
     * @param anzahl Anzahl der Operationen
     */
    void ShakerSortZählerSetzen(String zeit)
    {
        anzahlShaker.setText(zeit);
    }
}
