
/**
 * Führt die gewünschten Laufzeittests durch.
 * 
 * @author Albert Wiedemann
 * @version 1.0
 */
class TestSortieren
{
    /** Anzahl der Datenelemente im Feld */
    private int anzahl;
    /** Erzeugerelement für die Schlüsselwerte */
    private Generator g;
    /** Die Ausgangsdaten */
    private String[] daten;
    /** Die Zähler für die relevanten Operationen */
    private int zählerBubble, zählerShaker;

    /**
     * Legt die benötigten Objekte an und besetzt die Attributwerte.
     * @param anzahl Anzahl der zu sortierenden Datenelemente
     */
    TestSortieren(int anzahl)
    {
        this.anzahl = anzahl;
        g = new Generator(10);
        daten = new String[anzahl];
        for (int i = 0; i < anzahl; i += 1)
        {
            daten[i] = g.BezeichnerGenerieren();
        }
        zählerBubble = 0;
        zählerShaker = 0;
        String[] d = daten.clone();
        BubbleSort(d);
        d = daten.clone();
        ShakerSort(d);
    }

    /**
     * Sortiert das gegebene Feld durch Vertauschen falsch stehender Nachbarelemente.
     * @param d das zu sortierende Feld
     */
    private void BubbleSort(String[] d)
    {
        String hilf;
        for (int i = 0; i < d.length; i += 1)
        {
            for (int j = 0; j < d.length - 1; j += 1)
            {
                zählerBubble += 1;
                if (d[j].compareTo(d[j + 1]) > 0)
                {
                    hilf = d[j];
                    d[j] = d[j + 1];
                    d[j + 1] = hilf;
                }
            }
        }
    }
    
    /**
     * Sortiert das gegebene Feld durch Vertauschen falsch stehender Nachbarelemente im Hin- und Rücklauf.
     * @param d das zu sortierende Feld
     */
    private void ShakerSort(String[] d)
    {
    }
    
    /**
     * Meldet die Anzahl relevanter Operationen für die Sortierung durch Vertauschen falsch stehender Nachbarelemente.
     * @return Anzahl der Operationen
     */
    int ZählerFürBubbleSortGeben()
    {
        return zählerBubble;
    }
    
    /**
     * Meldet die Anzahl relevanter Operationen für die Sortierung durch Vertauschen falsch stehender Nachbarelemente im Hin- und Rücklauf.
     * @return Anzahl der Operationen
     */
    int ZählerFürShakerSortGeben()
    {
        return zählerShaker;
    }
}
