import java.util.ArrayList;

/**
 * Lösung zu 39. BWINf Runde 1 Aufgabe 1 über BruteForce:
 * Alle möglichen Wortkombinationen werden durch die Permutationen bestimmt. 
 * Der Ansatz funktioniert nur mit dem ersten Text,
 * die weiteren haben ein Speicherproblem (Heap)
 * 
 * @author Peter Brichzin
 * @version 11.11.24
 */
class BruteForceWortraetselLoeser
{
    /** zu verteilende Wörter als Feld */
    ArrayList<String> wörter;

    /** Lücken für die Wörter, die neben einzelnenen Buchstaben, den Plätzen für Buchstaben (gekennzeichnet durch "_") auch Satzzeichen enthalten */
    ArrayList<String> wortlückeMitBuchstabenplatzhalter;

    /** Feld für das Endergebnis: zur Lücke passendes Wort (ohne Platzhalter "_" für fehlende Buchstaben)  */
    ArrayList<String> wortlückeOhneBuchstabenplatzhalter;

    /** Felder zur Bestimmung Speicherung der Permutationen (Brute Force) */
    ArrayList<String> teilergebnisPermutation;
    ArrayList<ArrayList<String>> ergebnisPermutation;

    /**
     * Worträtsel Konstruktor:
     * - liest die Daten ein
     * 
     * Zum Start der Lösung muss noch die Methode LösenMitBruteForce aufgerufen werden.
     *
     * @param rätselnummer Ziffer zwischen 0 und 5, die das zu lösende Rätsel festlegt
     */
    BruteForceWortraetselLoeser(int rätselnummer)
    {
        // Daten einlesen und damit die Felder wörter und wortlückeMitBuchstabenplatzhalter initialisieren
        DatenEinlesen(rätselnummer);

        // wortlückeOhneBuchstabenplatzhalter wird initialisiert mit einer Kopie von wortlückeMitBuchstabenplatzhalter 
        // -> an späterer Stelle kann verglichen werden, ob Satzzeichen wieder ergänzt werden müssen
        wortlückeOhneBuchstabenplatzhalter = new ArrayList<String>();
        wortlückeOhneBuchstabenplatzhalter.addAll(wortlückeMitBuchstabenplatzhalter);

    }

    /**
     * Ermittelt  die Lösung des Worträtsels
     */
    void LösenMitBruteForce()
    {
        // Felder zur Speicherung der Permutationen erzeugen
        teilergebnisPermutation = new ArrayList<String>();
        ergebnisPermutation = new ArrayList<>();
        PermutationWörterBestimmen();
        //System.out.println("Anzahl der Permutationen " + ergebnisPermutation.size());
        PermutationenÜberprüfen();
    }

    /**
     * Methode PermutationWörterBestimmen bestimmt alle Permutationen der Wörter
     * im Attribut wörter und speichert diese im Attribut ergebnisPermutaion.
     */
    private void PermutationWörterBestimmen()
    {
        if (wörter.size()==1)                            //Rekursionsende: nur ein Wort in der Menge
        {
            teilergebnisPermutation.add(wörter.get(0));             //letztes Wort wird zum Teilergebnis hinzugefügt
            ergebnisPermutation.add(new ArrayList<>(teilergebnisPermutation)); //Teilergebnis ist fertig -> wird in globalem Attribut gespeichert (als neue Liste) 
            // System.out.println(teilergebnisPermutation);   // mögliche Ausgabe der Permutation, welche aber den Programmablauf verlangsamt.
            teilergebnisPermutation.remove(teilergebnisPermutation.size()-1);  //Teilergebnis wird reduziert um das letzte Wort
        }
        else
        {
            //Rekursionsschritt für alle Wörter die in der Wortmenge enthalten sind:
            // ein Wort wird genommen und über "teilergebnis" konkateniert mit allen Permutationen der restlichen Wörter
            for (int i=0; i < wörter.size(); i = i+1)    
            {
                //entsprechend dem Index wird das aktuelle Wort dem Teilergebnis hinzugefügt und aus der Wortliste entfernt
                String aktuellesWort = wörter.get(i);
                teilergebnisPermutation.add(aktuellesWort);
                wörter.remove(i);
                //rekursiver Aufruf (mit Kopie der aktuellen Wortliste)
                PermutationWörterBestimmen();
                //Umkehrung der Schritte vor dem rekursiven Aufruf
                //aktuelles Wort wird vom Teilergebnis weggenommen und der Wortliste hinzugefügt
                wörter.add(i, aktuellesWort);
                teilergebnisPermutation.remove(teilergebnisPermutation.size()-1);
            }
        }
    }

    /**
     * Methode PermutationenÜberprüfen überprüft, ob eine der Permutationen in die Wortfolge mit Lücken passt
     * und gibt diese gegebenenfalls aus.
     */
    private void PermutationenÜberprüfen()
    {
        String wortlückeOhneSatzzeichen;
        wortlückeOhneSatzzeichen = "";
        String satzzeichen;
        satzzeichen = "";

        int anzahlPassendeWorte;
        anzahlPassendeWorte = 0;

        for (ArrayList<String> p: ergebnisPermutation)
        {
            wortlückeOhneBuchstabenplatzhalter.clear();
            wortlückeOhneBuchstabenplatzhalter.addAll(wortlückeMitBuchstabenplatzhalter);
            anzahlPassendeWorte = 0;

            for (int j=0; j < p.size(); j = j+1)
            { 
                String wortkandidat;
                wortkandidat = p.get(j);
                String wortlücke;
                wortlücke = wortlückeOhneBuchstabenplatzhalter.get(j);

                //Eliminierung der Satzzeichen
                if (wortlücke.charAt(wortlücke.length()-1)==',' || wortlücke.charAt(wortlücke.length()-1)=='.' || wortlücke.charAt(wortlücke.length()-1)=='?' || wortlücke.charAt(wortlücke.length()-1)==';' || wortlücke.charAt(wortlücke.length()-1)=='!')
                {
                    satzzeichen = "" + wortlücke.charAt(wortlücke.length()-1);
                    wortlückeOhneSatzzeichen = wortlücke.substring(0, wortlücke.length()-1);
                }
                else
                {
                    wortlückeOhneSatzzeichen = wortlücke;
                    satzzeichen = "";
                }

                //eigentlicher Vergleich
                boolean wortPasstInLücke;
                wortPasstInLücke = false;
                if (wortkandidat.length() == wortlückeOhneSatzzeichen.length())
                {
                    wortPasstInLücke = true;
                    for (int i=0; i < wortkandidat.length(); i =i+1)
                    {
                        if (!(wortlückeOhneSatzzeichen.charAt(i) == wortkandidat.charAt(i) || wortlückeOhneSatzzeichen.charAt(i) == '_'))
                        {
                            wortPasstInLücke = false;
                        }
                    }
                }

                //Übernahme als Ergebnis falls der Vergleich erfolgreich, ende dieser Wiederholungsanweisung sonst
                if (wortPasstInLücke)
                {
                    wortlückeOhneBuchstabenplatzhalter.set(j, wortkandidat + satzzeichen); 
                    anzahlPassendeWorte = anzahlPassendeWorte +1;

                }
                else
                {
                    break;
                }

            }
            if (anzahlPassendeWorte == wortlückeOhneBuchstabenplatzhalter.size())
            {
                System.out.println("Ergebnis gefunden :-)");
                break;
            }
        }
        System.out.println(wortlückeOhneBuchstabenplatzhalter);
        System.out.println("und als Satz");

        ErgebnisAusgeben();
    }

 
    /**
     * Teilt Zeichenkette mit Leerzeichen als Trennzeichen in Wörter und speichert diese in einer Liste speichern
     * 
     * @param  zeichenkette     zu teilende Zeichenkette
     * @return                  Liste mit Wörtern
     */
    private ArrayList<String> ZeichenketteTeilen(String zeichenkette)
    {
        ArrayList<String> wörter;
        wörter = new ArrayList<String>();

        String s;
        s = "";
        for (int i=0; i<zeichenkette.length(); i = i+1)
        {
            if (zeichenkette.charAt(i) == ' ')
            {
                wörter.add(s);
                s= "";
            }
            else
            {
                s = s + zeichenkette.charAt(i);
            }
        }
        wörter.add(s); //Sollten die ersten beiden Zeilen leer sein, würde ein leerer String gespeichert werden

        for (String wort: wörter)
        {
            System.out.println(wort);
        }

        return  wörter;
    }

    /**
     * Gibt das Ergebnis der Lösungssuchge auf Konsole aus
     */
    private void ErgebnisAusgeben()
    {
        String ergebnis;
        ergebnis = "";
        for (String s: wortlückeOhneBuchstabenplatzhalter)
        {
            ergebnis = ergebnis + s + " ";
        }
        System.out.println(ergebnis);
    }

    /**
     * Methode DatenEinlesen öffnet abhängig von der Rätselnummer die passende Textdatei, 
     * liest die zwei Zeichenketten mit den Wörtern bzw. Wortlücken ein, trennt diese bei den Leerzeichen und füllt
     * die Felder wörter bzw. wortlückeMitBuchstabenplatzhalter 
     * Falls eine falsche Nummer eingegeben wird, bricht das Programm mit einer FileNotFound Exception ab.
     *
     * @param rätselnummer Eine Nummer zwischen 0 und 5 
     */
    private void DatenEinlesen(int rätselnummer)
    {
        /** File Reader zum Lesen der als Textdatein gegebenen Raetsel */
        TextFileReader reader;
        String dateiname;
        dateiname ="";

        // Textdatei auswählen und öffen
        if (rätselnummer >= 0 && rätselnummer <=4)
        {
            dateiname = "raetsel" + rätselnummer + ".txt";
            reader = new TextFileReader(dateiname);

            // Daten auslesen 
            /** Lückentext  */ 
            String lückentext;
            lückentext = reader.LückentextGeben();

            /** einzusetzende Wörter als eine einzige Zeichenkette mit Leerzeichen getrennt */ 
            String wörterAlsZeichenkette;
            wörterAlsZeichenkette = reader.WörterAlsZeichenketteGeben();

            // Rätsel auf Konsole ausgeben
            System.out.println("Fülle den Lückentext ");
            System.out.println(lückentext);
            System.out.println("mit folgenden Wörtern ");
            System.out.println(wörterAlsZeichenkette);

            // Daten in Feldern speichern
            wortlückeMitBuchstabenplatzhalter = ZeichenketteTeilen(lückentext); 
            wörter = ZeichenketteTeilen(wörterAlsZeichenkette); 
        }
        else
        {
            System.out.println(" Es sind nur Rätselnummern zwischen 0 und 5 erlaubt!!");
            wortlückeMitBuchstabenplatzhalter = new ArrayList();
            wörter = new ArrayList(); 
        }
    }
}
