import java.util.ArrayList;
import java.util.Arrays;
/**
 * Wörträtsel (Lösung zu 39. BWINf Runde 1 Aufgabe 1)
 * 
 * @author Peter Brichzin
 * @version 6.1.25
 */
class LottasWortraetselLoeser
{
    /** zu verteilende Wörter als Feld */ 
    private ArrayList<String> wörter;

    /** Lücken für die Wörter, die neben einzelnenen Buchstaben, den Plätzen für Buchstaben (gekennzeichnet durch "_") auch Satzzeichen enthalten */
    private ArrayList<String> wortlücken;

    /** Lücken für die Wörter, die im Idealfall nur noch Buchstaben und Satzzeichen, 
     * aber keine Plätze für Buchstaben (gekennzeichnet durch "_") enthalten
     */
    private ArrayList <String> wortlückenErgebnis;

    /** für jede Lücke die Indizes der Wörter die passen */
    private ArrayList<ArrayList<Integer>> wortkandidatenFürLücken;

    /**
     * Worträtsel Konstruktor:
     * - liest die Daten ein
     * - erzeugt und initialisiert die Felder, die zur Berechnung nötig sind
     * - startet den Lösungsprozess
     * - gibt das Ergebnis aus
     *
     * @param rätselnummer Ziffer zwischen 0 und 5, die das zu lösende Rätsel festlegt
     */
    LottasWortraetselLoeser(int rätselnummer)
    {
        // Daten einlesen und damit die Felder wörter und wortlücken initialisieren
        DatenEinlesen(rätselnummer);

        FelderErzeugenUndInitialisieren();

    }

    /**
     * Für jede Lücke (Liste wortlücken) werden die Wörter (Liste Wörter)
     * bestimmt, die in die Lücke passen. Gespeichert werden zu jedem Index der
     * Liste wortlücken alle Indizes (der Liste Wörter) passender Wörter. 
     */
    void WortkandidatenBestimmen()
    {
        //ToDo
    }

    /**
     * Methode die nach einem Greedy-Verfahren die Lösungskandidaten auswählt.
     */
    void LösungskandidatenAuswählenGreedy()
    {
        //ToDo
    }

    /**
     * Methode die nach einem Backtracking-Verfahren die Lösungskandidaten auswählt.
     */
    void LösungskandidatenAuswählenBacktracking()
    {
        //ToDo
    }

    /**
     * Methode DatenEinlesen öffnet abhängig von der Rätselnummer die passende Textdatei, 
     * liest die zwei Zeichenketten mit den Wörtern bzw. Wortlücken ein, trennt diese bei den Leerzeichen und füllt
     * die Felder wörter bzw. wortlücken 
     * Falls eine falsche Nummer eingegeben wird, bricht das Programm mit einer FileNotFound Exception ab.
     *
     * @param rätselnummer Eine Nummer zwischen 0 und 5 
     */
    void DatenEinlesen(int rätselnummer)
    {
        /** File Reader zum Lesen der als Textdatein gegebenen Raetsel */
        TextFileReader reader;
        String dateiname;
        dateiname = "";

        // Textdatei auswählen und öffen
        if (rätselnummer >= 0 && rätselnummer <= 5)
        {
            dateiname = "raetsel" + rätselnummer + ".txt";
            reader = new TextFileReader(dateiname);

            // Daten auslesen 
            /** Lückentext  */ 
            String lückentext;
            lückentext = reader.LückentextGeben();

            /** einzusetzende Wörter als eine einzige Zeichenkette mit Leerzeichen getrennt */ 
            String wörterAlsZeichenkette;
            wörterAlsZeichenkette = reader.WörterAlsZeichenketteGeben();

            // Rätsel auf Konsole ausgeben
            System.out.println("Fülle den Lückentext ");
            System.out.println(lückentext);
            System.out.println("mit folgenden Wörtern ");
            System.out.println(wörterAlsZeichenkette);

            // Daten in Feldern speichern
            wortlücken = ZeichenketteTeilen(lückentext); 
            wörter = ZeichenketteTeilen(wörterAlsZeichenkette); 
        }
        else
        {
            System.out.println(" Es sind nur Rätselnummern zwischen 0 und 5 erlaubt!!");
            wortlücken = new ArrayList();
            wörter = new ArrayList(); 
        }
    }

    /**
     * Methode FelderErzeugenUndInitialisieren erzeugt und initialisiert die 
     * Attribute (Felder), welche während der Berechnung benötigt werden.
     */
    private void FelderErzeugenUndInitialisieren()
    {
        // Feld wortkandidatenFürLücken erzeugen und 
        // bei jedem Feldelement ein int Feld mit einem einzigen Element -1 hinzufügen als Zeichen,
        // dass noch kein Wortkandidat für die entsprechende Lücke gefunden wurde.
        wortkandidatenFürLücken = new ArrayList<>();
        for (int i=0; i< wortlücken.size(); i = i+1)
        {
            wortkandidatenFürLücken.add(new ArrayList<>(Arrays.asList(-1)));
        }

        wortlückenErgebnis = new ArrayList<>(wortlücken); //Achtung wortlückenErgebnis = wortlücken ist falsch, da zur Originalliste eine Referenz erstellt wird und dadurch alle Veränderungen bei beiden Listen stattfinden.
    }

    /**
     * Teilt Zeichenkette mit Leerzeichen als Trennzeichen in Wörter und speichert diese in einer Liste speichern
     * 
     * @param zeichenkette  zu teilende Zeichenkette
     * @return Liste mit Wörtern
     */
    private ArrayList<String> ZeichenketteTeilen(String zeichenkette)
    {
        ArrayList<String> wörter;
        wörter = new ArrayList<String>();

        String s;
        s = "";
        for (int i=0; i<zeichenkette.length(); i = i+1)
        {
            if (zeichenkette.charAt(i) == ' ')
            {
                wörter.add(s);
                s = "";
            }
            else
            {
                s = s + zeichenkette.charAt(i);
            }
        }
        wörter.add(s); //Sollten die Zeichenkette leer sein, würde eine leere Zeichenkette gespeichert werden

        return  wörter;
    }
}
