import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import java.util.ArrayList;

/**
 * TextFileReader liest die Textdateien mit den Rätseln und stellt über die 
 * Methoden den Lückentext bzw. die Wörter als Zeichenketten zur Verfügung.
 *
 * @author Peter Brichzin)
 * @version 11.11.24
 */
class TextFileReader 
{
	/** Der Inhalt der Datei zeilenweise */
    private ArrayList<String> dateiinhalt;

    /**
     * TextFileReader Liest die Daten des Beispiels der Einstiegsaufgabe ein.
     */
    TextFileReader()
    {
        this("raetsel0.txt");
    }
    
    /**
     * TextFileReader liest die Daten der angegebenen Textdatei ein.
     * @param dateiname Dateiname "raetsel0.txt" bis "raetsel5.txt" ist möglich
     */
    TextFileReader(String dateiname)
    {
        dateiinhalt = new ArrayList<String>();
        try
        {
            File file = new File(dateiname);
            Scanner scanner = new Scanner(file);

            while (scanner.hasNextLine())
            {
                String line = scanner.nextLine();
                dateiinhalt.add(line);
            }

            scanner.close();
        } catch (FileNotFoundException e)
        {
            System.out.println("Datei nicht gefunden: " + e.getMessage());
        }
    }
    
    /**
     * Gibt den Lückentext als Zeichenkette zurück.
     * @return der Lückentext
     */
    String LückentextGeben()
    {
        return dateiinhalt.get(0);
    }
    
    /**
     * Gibt die Wörter als Zeichenkette zurück.     
     * @return die Wörter
     */
    String WörterAlsZeichenketteGeben()
    {
        return dateiinhalt.get(1);
    }
}
