import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import java.util.ArrayList;

/**
 * TextFileReader liest eine Textdatei mit ganzen Zahlen aus und und stellt diese über die 
 * Methode DatenAuslesen als Zahlenfeld zur Verfügung.
 * 
 * @author Peter Brichzin
 * @version 11.11.24
 */
class TextFileReader 
{
    /** Feld der Gesundheitsdaten */
    ArrayList<Integer> daten;

    /**
     * TextFileReader Liest die Daten der angegebenen Textdatei ein.
     *
     * @param dateinameNeu Dateiname 
     */
    TextFileReader(String dateiname)
    {
        daten = new ArrayList<Integer>();
        try 
        {
            File file = new File(dateiname); 
            Scanner scanner = new Scanner(file);

            while (scanner.hasNextLine()) 
            {
                String line = scanner.nextLine();
                System.out.println(line);
                try {
                    int zahl = Integer.parseInt(line.trim()); // Umwandlung in int
                    daten.add(zahl);
                } catch (NumberFormatException e) {
                    System.out.println("Ungültige Zahl in Zeile: " + line);
                }
            }

            scanner.close();
        } catch (FileNotFoundException e) 
        {
            System.out.println("Datei nicht gefunden: " + e.getMessage());
        }
    }

    /**
     * Gibt den Dateieinhalt zurück
     * @return Dateiinhalt als Feld von Zahlen
     */
    ArrayList<Integer> DatenAuslesen() 
    {
        return daten;
    }
}
