
/**
 * Kantenbeschreibung für die Konstruktion des minimalen Spannbaums
 * 
 * @author Johannes Neumeyer
 * @version 1.0
 */
class Kante
{
    /** Länge der Kante */
    private int länge;
    /** Startknoten der Kante */
    private Knoten start;
    /** Zielknoten der Kante */
    private Knoten ziel;
    /** Symbol für die Darstellung der Kante */
    private KantenSymbol symbol;

    /**
     * Besetzt die Attribute
     */
    Kante(Knoten start, Knoten ziel, int länge)
    {
        this.start = start;
        this.ziel = ziel;
        this.länge = länge;
        symbol = new KantenSymbol(start.SymbolGeben(), ziel.SymbolGeben(), false, String.valueOf(länge), 3, "blau");
    }
    
    /**
     * Setzt die Farbe der Darstellung
     * @param f die (neue) Farbe
     */
    void FarbeSetzen(String f)
    {
        symbol.FarbeSetzen(f);
    }

    /**
     * Meldet den Startknoten
     * @return Startknoten
     */
    Knoten StartGeben()
    {
        return start;
    }
    
    /**
     * Meldet den Zielknoten
     * @return Zielknoten
     */
    Knoten ZielGeben()
    {
        return ziel;
    }
    
    /**
     * Meldet die Länge der Kante
     * @return Länge
     */
    int LängeGeben()
    {
        return länge;
    }
    
    /**
     * Meldet das Kantensymbol
     * @return Kantensymbol
     */
    KantenSymbol KantensymbolGeben()
    {
        return symbol;
    }
}
