import java.util.ArrayList;
/**
 * Beschreibt einen Knoten
 * 
 * @author Albert Wiedemann
 * @version 1.0
 */
class Knoten
{
    /** Der Bezeichner des Knotens */
    private String bezeichner;
    /** Das Darstellungssymbol des Knotens */
    private KnotenSymbol symbol;
    /** Die Länge des bisherigen Wegs in Kantenschritten */
    private int länge;
    
    
    /** Vorgängerknoten für die Union-Find-Datenstrutkur bzw. null, falls kein Vorgänger existiert */
    private Knoten vorgänger;
    /** Hilfsvariable für die Preorder-Traversierung */
    private boolean dfsBesucht;
    /** Katen zu den Nachbarknoten im minimalen Spannbaum */
    private ArrayList<Kante> baumnachbarn;

    /**
     * Besetzt die Attribute und legt das Knotensymbol an.
     * @param bezeichner Bezeichner
     * @param x x-Koordinate
     * @param y y-Koordinate
     */
    Knoten (String bezeichner, int x, int y)
    {
        this.bezeichner = bezeichner;
        länge = 0;
        vorgänger = null;
        symbol = new KnotenSymbol(x, y, 20, "weiß", bezeichner);

        dfsBesucht = false;
        baumnachbarn = new ArrayList<Kante>();
    }

    /**
     * Meldet den Bezeichner des Knotens zurück.
     * @return Bezeichner
     */
    String BezeichnerGeben()
    {
        return bezeichner;
    }

    /**
     * Meldet das Symbol des Knotens zurück.
     * @return Bezeichner
     */
    KnotenSymbol SymbolGeben()
    {
        return symbol;
    }

    /**
     * Setzt die Farbe der Darstellung
     * @param f die (neue) Farbe
     */
    void FarbeSetzen(String f)
    {
        symbol.FarbeSetzen(f);
    }

    /**
     * Setzt die Weglänge
     * @param l die (neue) Länge
     */
    void LängeSetzen(int l)
    {
        länge = l;
    }

    /**
     * Meldet die Weglänge zurück.
     * @return Weglänge
     */
    int LängeGeben()
    {
        return länge;
    }

    /**
     * Setzt den Vorgänger
     * @param v der Vorgänger
     */
    void VorgängerSetzen(Knoten v)
    {
        vorgänger = v;
    }

    /**
     * Meldet den Vorgänger zurück.
     * @return Vorgänger
     */
    Knoten VorgängerGeben()
    {
        return vorgänger;
    }

    /**
     * Fügt einen Nachbarknoten hinzu
     * @param n Kante zum Nachbarknoten
     */
    void BaumnachbarSetzen(Kante n)
    {
        baumnachbarn.add(n);
    }

    /**
     * Gibt das Feld der Kanten zu den Nachbarknoten zurück
     * @return Kanten zu den Nachbarknoten
     */
    ArrayList<Kante> BaumnachbarnGeben()
    {
        return baumnachbarn;
    }
    
    /**
     * Meldet den Wert der Variablen dsfBesucht
     * @return dsfBesucht
     */
    boolean DfsBesuchtGeben()
    {
        return dfsBesucht;
    }
    
    /**
     * Setzt den Wert der Variablen dsfBesucht auf wahr (besucht)
     */
    void DfsBesuchtSetzen()
    {
        dfsBesucht = true;
    }
    
    /**
     * Setzt den Wert der Variablen dsfBesucht auf falsch (nicht besucht)
     */
    void DfsUnbesuchtSetzen()
    {
        dfsBesucht = false;
    }

}
