import random
import time

class Passwoerter:
    """
    Ermittelt den Zeitbedarf, um alle Passwoerter gegebener Laenge und mit
    gegebenem Zeichenvorrat durchzuprobieren
     
    @author Albert Wiedemann
    @version 1.0
    """

    def __init__(self):
        """
        Besetzt die Attribute mit Default-Werten
        """
        self.passwort = ""
        self.zeichen = []
        self.start = 0

    def Alphabet26Setzen(self):
        """
        Setzt alle Grossbuchstaben als Zeichenvorrat
        """
        self.zeichen = [chr(ord('A') + i) for i in range(26)]

    def Alphabet52Setzen(self):
        """
        Setzt alle Buchstaben als Zeichenvorrat
        """
        self.zeichen = [chr(ord('A') + i) for i in range(26)]
        self.zeichen += [chr(ord('a') + i) for i in range(26)]

    def Alphabet78Setzen(self):
        """
        Setzt alle Buchstaben, Ziffern und genuegend Sonderzeichen als
        Zeichenvorrat
        """
        self.zeichen = [chr(ord('A') + i) for i in range(26)]
        self.zeichen += [chr(ord('a') + i) for i in range(26)]
        self.zeichen += [chr(ord('0') + i) for i in range(10)]
        self.zeichen += [chr(ord('!') + i) for i in range(15)]

    def PasswortErzeugen(self, stellenanzahl):
        """
        Erzeugt ein Passwort gegebener Laenge aus dem vorhandenen
        Zeichenvorrat.
        :param stellenanzahl: Anzahl der Stellen fuer das Passwort
        """
        zufall = random.Random()
        self.passwort = ""
        for i in range(stellenanzahl):
            self.passwort += zufall.choice(self.zeichen)

    def NaechsteStelleTesten(self, anfangsFolge):
        """
        Bearbeitet eine Stelle
        :param anfangsFolge: die bisherige Zeichenfolge fuer den
        Passworttest
        """
        for ch in self.zeichen:
            test = anfangsFolge + ch
            if len(self.passwort) == len(test):
                if self.passwort == test:
                    print("Gefunden nach: " +
                          str(int((time.perf_counter_ns() - self.start) / 1000)) +
                          " µs")
            else:
                self.NaechsteStelleTesten(test)

    def PasswortTest(self, stellenanzahl, alphabetlaenge):
        """
        Testet alle Moeglichkeiten fuer das Passwort durch
        :param stellenanzahl: Anzahl der Stellen fuer das Passwort
        :param alphabetlaenge: Anzahl der Zeichen im Alphabet, erlaubt sind
        26, 52 oder 78 Zeichen
        """
        if alphabetlaenge == 26:
            self.Alphabet26Setzen()
        elif alphabetlaenge == 52:
            self.Alphabet52Setzen()
        elif alphabetlaenge == 78:
            self.Alphabet78Setzen()
        else:
            print("Falsche Alphabetlaenge", alphabetlaenge)
            return
        self.PasswortErzeugen(stellenanzahl)
        self.start = time.perf_counter_ns()
        self.NaechsteStelleTesten("")
        print("Gesamtlaufzeit: " +
              str(int((time.perf_counter_ns() - self.start) / 1000)) + " µs")