"""
@author Albert Wiedemann  
@version 1.0
"""

import random
import time

class Generator:
    """
    Generiert zufaellige Bezeichner vom Typ String gegebener Laenge.
    """

    def __init__(self, laenge):
        """
        Initialisiert den Zufallsgenerator.
        
        :param laenge: Die Laenge der zu generierenden Bezeichner
        """
        self.zufall = random.Random()
        self.laenge = laenge
        self.zeichen = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j']

    def BezeichnerGenerieren(self):
        """
        erzeugt einen neuen Bezeichner.
        
        :return: der neue Bezeichner
        """
        resultat = ""
        for i in range(self.laenge):
            resultat = resultat + self.zeichen[self.zufall.randint(0, len(self.zeichen) - 1)]
        return resultat


class TestSuche:
    """
    Fuehrt die gewuenschten Laufzeittests durch.
    """

    def __init__(self):
        """
        Legt die benoetigten Objekte an und besetzt die Attributwerte.
        """
        self.anzahlSuchvorgaenge = 100000
        self.g = Generator(10)
        self.zufall = random.Random()
        self.schluesselwerte = []
        self.sortierteSchluesselwerte = []

    def DatenErzeugen(self, anzahl):
        """
        Besetzt die Felder mit der gewuenschten Anzahl von Elementen

        :param anzahl: Anzahl der Datenelemente
        """
        self.schluesselwerte.clear()
        self.sortierteSchluesselwerte.clear()
        for i in range(anzahl):
            neu = self.g.BezeichnerGenerieren()
            self.schluesselwerte.append(neu)
            if i == 0:
                self.sortierteSchluesselwerte.append(neu)
            else:
                pos = i
                while (pos > 0 and 
                       self.sortierteSchluesselwerte[pos - 1] > neu):
                    pos -= 1
                self.sortierteSchluesselwerte.insert(pos, neu)

    def TestWaehlen(self):
        """
        Zu suchendes Testelement auswaehlen.
        
        :return: Testelement
        """
        return self.schluesselwerte[self.zufall.randint(0, len(self.schluesselwerte) - 1)]

    def UnsortierteSucheDurchfuehren(self):
        """
        Misst die Zeit fuer einen Suchvorgang im unsortierten Feld.
        Um dem Mittelwert nahe zu kommen,wird der Vorgang
        'anzahlSuchvorgaenge' Mal wiederholt und die
        durchschnittliche Suchzeit ermittelt.
        """
        zeit = 0
        zaehlergesamt = 0
        for i in range(1, self.anzahlSuchvorgaenge + 1):
            gesucht = self.TestWaehlen()
            start = time.perf_counter_ns()
            pos = 0
            zaehler = 0
            while (pos < len(self.schluesselwerte) and 
                   self.schluesselwerte[pos] != gesucht):
                zaehler += 1
                pos += 1
            ende = time.perf_counter_ns()
            zeit += ende - start
            zaehlergesamt += zaehler
        print("{}µs, {} Vergleiche".format(
            zeit // self.anzahlSuchvorgaenge,
            zaehlergesamt // self.anzahlSuchvorgaenge), end="")

    def SortierteSucheDurchfuehren(self):
        """
        Misst die Zeit fuer einen Suchvorgang im sortierten Feld.
        Um dem Mittelwert nahe zu kommen,wird der Vorgang
        'anzahlSuchvorgaenge' Mal wiederholt und die
        durchschnittliche Suchzeit ermittelt.
        """
        zeit = 0        
        for i in range(1, self.anzahlSuchvorgaenge + 1):
            gesucht = self.TestWaehlen()
            start = time.perf_counter_ns()
            min_idx = 0
            max_idx = len(self.sortierteSchluesselwerte)
            while True:
                mitte = (max_idx + min_idx) // 2
                res = (self.sortierteSchluesselwerte[mitte] > gesucht) - (self.sortierteSchluesselwerte[mitte] < gesucht)
                if res == 0:
                    break
                elif res < 0:
                    min_idx = mitte + 1
                else:
                    max_idx = mitte
                if min_idx >= max_idx:
                    break
            ende = time.perf_counter_ns()
            zeit += ende - start
        print("{}µs".format(zeit // self.anzahlSuchvorgaenge), end="")


    def DurchschnittsTest(self, anzahl):
        """
        Bestimmt die durschnittlichen Suchzeiten.

        :param anzahl: Anzahl der Feldelemente
        """
        self.DatenErzeugen(anzahl)
        print("Suche im unsortierten Feld mit {} Elementen: ".format(anzahl), end="")
        self.UnsortierteSucheDurchfuehren()
        print()
        print("Suche im sortierten Feld mit {} Elementen: ".format(anzahl), end="")
        self.SortierteSucheDurchfuehren()
        print()
