"""
Autor: Albert Wiedemann
Version: 1.0
"""

import random

class Generator:
    """
    Generiert zufaellige Bezeichner vom Typ String gegebener Laenge.
    """

    def __init__(self, laenge):
        """
        Initialisiert den Zufallsgenerator.
        :param laenge Die Laenge der zu generierenden Bezeichner
        """
        self.zufall = random.Random()
        self.zeichen = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j']
        self.laenge = laenge

    def BezeichnerGenerieren(self):
        """
        erzeugt einen neuen Bezeichner.
        :return der neue Bezeichner
        """
        resultat = ""
        for i in range(self.laenge):
            resultat = resultat + self.zeichen[self.zufall.randint(0, len(self.zeichen) - 1)]
        return resultat


class TestSortieren:
    """
    Fuehrt die gewuenschten Laufzeittests durch.
    """

    def __init__(self, anzahl):
        """
        Legt die benoetigten Objekte an und besetzt die Attributwerte.
        :param anzahl Anzahl der zu sortierenden Datenelemente
        """
        self.anzahl = anzahl
        self.g = Generator(10)
        self.daten = [self.g.BezeichnerGenerieren() for _ in range(anzahl)]
        # Hier Attribute fuer Zaehler ergaenzen

        d = list(self.daten)
        self.SelectionSort(d)
        d = list(self.daten)
        self.BubbleSort(d)
        d = list(self.daten)
        self.MergeSort(d)

    def SelectionSort(self, d):
        """
        Sortiert das gegebene Feld durch Auswahl des jeweils kleinsten Elements im
        unsortierten Rest.
        :param d das zu sortierende Feld
        """
        for i in range(len(d) - 1):
            pos = i
            for j in range(i + 1, len(d)):
                if d[j] < d[pos]:
                    pos = j
            d[i], d[pos] = d[pos], d[i]

    def BubbleSort(self, d):
        """
        Sortiert das gegebene Feld durch Vertauschen falsch stehender Nachbarelemente.
        :param d das zu sortierende Feld
        """
        for i in range(len(d)):
            for j in range(len(d) - 1):
                if d[j] > d[j + 1]:
                    d[j], d[j + 1] = d[j + 1], d[j]

    def Mischen(self, von, nach, minIndex, topIndex):
        """
        Sortiert den angegebenen Teilbereich des Feldes.
        pre: beide Felder enthalten die Ausgangsdaten, da der Start nicht vorhersagbar ist.
        :param von das Feld mit den Ausgangsdaten
        :param nach das Feld mit den Zieldaten
        :param minIndex der Index, ab dem sortiert werden soll
        :param topIndex der Index, bis zu dem (ausschliesslich) sortiert werden soll
        """
        if minIndex < topIndex - 1:
            mitte = (minIndex + topIndex) // 2
            self.Mischen(nach, von, minIndex, mitte)
            self.Mischen(nach, von, mitte, topIndex)
            posUnten = minIndex
            posOben = mitte
            pos = minIndex
            while pos < topIndex:
                if posUnten >= mitte:
                    while posOben < topIndex:
                        nach[pos] = von[posOben]
                        pos += 1
                        posOben += 1
                elif posOben >= topIndex:
                    while posUnten < mitte:
                        nach[pos] = von[posUnten]
                        pos += 1
                        posUnten += 1
                else:
                    if von[posUnten] <= von[posOben]:
                        nach[pos] = von[posUnten]
                        posUnten += 1
                    else:
                        nach[pos] = von[posOben]
                        posOben += 1
                    pos += 1

    def MergeSort(self, d):
        """
        Sortiert das gegebene Feld durch Mischen immer laengerer Teilfelder.
        :param d das zu sortierende Feld
        """
        nach = list(d)
        self.Mischen(d, nach, 0, len(d))
        for i in range(len(d)):
            d[i] = nach[i]

    def ZaehlerFuerSelectionSortGeben(self):
        """
        Meldet die Anzahl relevanter Operationen fuer die Sortierung durch direktes
        Auswaehlen.
        :return Anzahl der Operationen
        """
        #Hier Zaehlerwert ausgeben
        return 0

    def ZaehlerFuerBubbleSortGeben(self):
        """
        Meldet die Anzahl relevanter Operationen fuer die Sortierung durch Vertauschen
        falsch stehender Nachbarelemente.
        :return Anzahl der Operationen
        """
        #Hier Zaehlerwert ausgeben
        return 0

    def ZaehlerFuerMergesortGeben(self):
        """
        Meldet die Anzahl relevanter Operationen fuer die Sortierung durch Mischen.
        :return Anzahl der Operationen
        """
        #Hier Zaehlerwert ausgeben
        return 0


class SortierenTesten:
    """
    Hauptklasse des Programms.
    """

    def __init__(self):
        """
        Initialisiert ein Objekt dieser Klasse.
        """
        pass

    @staticmethod
    def main(args=None):
        """
        Startet das Programm.
        """
        anzahl = 100
        test = TestSortieren(anzahl)
        print("Anzahl Elemente:", anzahl)
        print("SelectionSort:    ", test.ZaehlerFuerSelectionSortGeben())
        print("BubbleSort:       ", test.ZaehlerFuerBubbleSortGeben())
        print("MergeSort:        ", test.ZaehlerFuerMergesortGeben())

SortierenTesten.main()
